#!/usr/bin/ksh
# http://www.utm.edu/research/primes/largest.html#lists
# http://www.utm.edu/research/primes/lists/small/10000.txt

GOAL="rsa-goal"
TMP="tmp.factor"
TIMEOUT="$1"
COMPUTE="test-factor"

rm ${TMP}.*
cat /dev/null > ${COMPUTE}

for X in 2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 101 103 107 109 113 127 131 137 139 149 151 157 163 167 173 179 181 191 193 197 199 211 223 227 229 233 239 241 251 257 263 269 271 277 281 283 293 307 311 313 317 331 337 347 349 353 359 367 373 379 383 389 397 401 409 419 421 431 433 439 443 449 457 461 463 467 479 487 491 499
 do
	for Y in 2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 101 103 107 109 113 127 131 137 139 149 151 157 163 167 173 179 181 191 193 197 199 211 223 227 229 233 239 241 251 257 263 269 271 277 281 283 293 307 311 313 317 331 337 347 349 353 359 367 373 379 383 389 397 401 409 419 421 431 433 439 443 449 457 461 463 467 479 487 491 499
	do

	cat /dev/null > ${TMP}.1 
	rsa2fml -xfactor ${X} -yfactor ${Y} -prime -size 32 -format 3 -file ${TMP}.1 
	cat ${TMP}.1 ${GOAL} | pparse > ${TMP}.2

	echo "Searching ${X}*${Y}"
	smodels < ${TMP}.2 > ${TMP}.3 &
	MYPID=$!
	
       	let TIME=${TIMEOUT}
	let DELTA=10

	let T=0
	let ALIVE=1
	while test $T -le ${TIME} -a ${ALIVE} -ne 0
	do
	    sleep ${DELTA}
	    let T+=${DELTA}
	    let ALIVE=`ps rx | grep -c ${MYPID}`
	done

	let ALIVE=`ps rx | grep -c ${MYPID}`
	if  test $ALIVE -ne 0
	then
	    echo "Timeout"
	    kill -9 ${MYPID}
	    RESULT="timeout"
	    CHOICES="-"
	    WRONG="-"
	else
	    echo "Done"
	    tail ${TMP}.3 > ${TMP}.4 
	    RESULT=`head -n 1 ${TMP}.4 | sed "s/ //g"`
	    TIME=`head -n 2 ${TMP}.4 | tail +2 | sed -n "s/\([^0-9\.]\)//pg"`
	    CHOICES=`head -n 3 ${TMP}.4 | tail +3 | sed -n "s/\([^0-9]\)//pg"`
	    WRONG=`head -n 4 ${TMP}.4 | tail +4 | sed -n "s/\([^0-9]\)//pg"`
	fi
	echo "${X}*${Y} & ${RESULT} & ${TIME} & ${CHOICES} & ${WRONG}" >> ${COMPUTE}

	done
done

