%********************    PROTEIN V2.33   ********************

%********************     t_header.pl    ********************

% Praedikate zur Durchfuehrung bzw Start des eigentlichen Beweises.

%************************************************************

:- module_interface( protein_proof).

:- global proof / 0,
	  protein_result / 1.

:- export protein_ae / 2.

:- begin_module( protein_proof).

% Unterdrueckung von "indefinite delay" Meldungen
:- set_error_handler( 272, true/0).

:- dynamic protein_result / 1,
	   protein_ae / 2.

protein_mode( proof).


% ---------- Haupteinsprungpunkt ----------

%%% proof
%%% Haupteinsprungpunkt zum Start des eigentlichen Beweises

proof :-
	h_init,
	h_proof( Trace),
	h_output( Trace), !.


%%% h_init
%%% Initialisierungen, Ausgabe Hinweise an den Benutzer

h_init :- 
	def_const( problem, Problem),
	(protein_flag( calculus, me) ; protein_flag( delayed_rme, off) -> true;
            setval( block, 0)),
	protein_flag( mmr, MMR),
	protein_flag( ec_pruning, ECP), 
	((MMR == gcwa ; MMR == model ; ECP == on) -> 
	    setval( restart, 0),
	    ((protein_flag(ctest,protein) ; MMR == model ; ECP == on) -> true;
		compile( "$HYPERHOME/hyper", t_hyper),
		use_module( t_hyper),
		protein_cc_init( Problem))
        ; true),
	(protein_flag( search, id_inf) -> setval( id_inf, 0); true),
	h_init_stat,
	h_init_dynamic,
	u_out( "%nproving %w...%n", [Problem]).

 
%%% h_proof( Trace)
%%% Start des Beweises mit Statistiken

h_proof( Trace) :-
	protein_flag( search, Search),
	(Search == id_tree -> u_out( "tree depth ") ;
        (Search == id_inf  -> u_out( "inference maximum ") ;
	(Search == id_term -> u_out( "term depth "); true))),
        statistics( runtime, _),
	h_retract,
        (h_start_proof( DepthOut, Trace) ; true),
        statistics( runtime, [_,Time]),
	Seconds is Time * 0.001,
	setval( proof_time, Seconds),
	(protein_flag( search, prolog) -> true; setval( proof_depth, DepthOut)).


%%% h_retract
%%% Loeschen aller dynamischen EIntraege fuer die neue Runde

h_retract :-
 	retract_all( protein_result(_)),
	retract_all( protein_ae(_,_)).


%%% h_output( Trace)
%%% Ausgabe der Statistik, Antworten, Trace

:- mode h_output( +).

h_output( Trace) :-    
	protein_result( proved), !,
	protein_flag( out_stream, S),
	h_write_stat( S), 
        h_write_answers( S),
        h_write_more_answers,
	h_write_tree( Trace),
        h_write_trc.

h_output( _) :-
	protein_result( indefinite), !,
	protein_flag( out_stream, S),
	h_write_stat( S), 
	u_out( "--- indefinite ---%n").

h_output( _) :-
	protein_flag( mmr, MMR),
	(MMR == gcwa ; MMR == model),
	protein_flag( ctest, CTest),
	(CTest == end ; CTest == protein ; MMR == model), !,
	protein_flag( out_stream, S),
	h_write_stat( S),
	h_mmr.

h_output( _) :-
	protein_flag( mmr, gcwa), !,
	protein_flag( out_stream, S),
	h_write_stat( S),
        u_out( "--- negation by failure to explain ---%n"). 
       
h_output( _) :-
	protein_flag( out_stream, S),
	h_write_stat( S),
        u_out( "--- failure ---%n"). 
       
        
% ---------- iterative deepening ----------

%%% h_search( Goal, Tiefe in Query, Eingabetiefe, Inkrement, Ausgabetiefe) 
%%% Suchen des Beweisen mit iterative deepening
%%% Die globale Variable more_depth wird benutzt, um zu ermitteln, ob eine
%%% Erhoehung der Tiefe noch sinnvoll ist. 

:- mode h_search( +, ?, +, ++, -).

% Starten des Beweises mit Tiefe Depth
h_search( Goal, Depth, Depth, _, Depth) :-
	h_print_depth( Depth),
        Goal,  
	(protein_result( _) -> true ;
           u_out( "+++ proved +++%n"),
           assert( protein_result( proved))).

% Erhoehen der Tiefe um Inc und Restart des Beweises
h_search( Goal, QDepth, InDepth, Inc, OutDepth) :-
        getval( more_depth, More_depth),
        (More_depth == 0 ->
           InDepth = OutDepth,
	   u_out( "--- proof not possible ---%n"), !
	;
           ZwiDepth is InDepth + Inc,
	   h_retract,
	   h_search( Goal, QDepth, ZwiDepth, Inc, OutDepth)).


%%% h_print_depth( Depth)
%%% Schreibt aktuelle Tiefe und initialisiert neues Level

:- mode h_print_depth( ++).

h_print_depth( Depth) :-
	u_out( "%w,", [Depth]),
	setval( more_depth, 0).

  
%---------- Antworten ----------

%%% h_write_answers( S)
%%% Ausgabe gefundene Antworten

h_write_answers( S) :-
	delayed_goals( DL),
        (protein_flag( answer_set_handling, on) ->
	   setof( Answer, member( protein_answer( Answer), DL), AnswerL)
        ;
	   bagof( Answer, member( protein_answer( Answer), DL), AnswerL)),
	printf( S, "%nAnswers%n-------%n", []),
	h_do_write_answers( S, AnswerL), !.
       
h_write_answers( _) :- !.
        

%%% h_do_write_answers( S, AnswerL)
%%% Schreibt gefundene Antwort

:- mode h_do_write_answers( ++, +).

h_do_write_answers( S, [Answer]) :- writeln( S, Answer), !.

h_do_write_answers( S, [Answer|AnswerR]) :-
	write( S, Answer), 
        write( S, ' ; '),
	h_do_write_answers( S, AnswerR).


%%% h_write_more_answers
%%% stoesst gegebenenfalls das Suchen nach weiteren Beweisen an.

h_write_more_answers :-
        protein_flag( answers, more),
	protein_flag( search, Search),
	u_out( "%n   More? (;)"),
	u_on_backtrack( h_retract), 
	(Search == id_tree -> u_on_backtrack( u_out("tree_depth "));
        (Search == id_inf  -> u_on_backtrack( u_out("inference maximum "));
	(Search == id_term -> u_on_backtrack( u_out("term depth ")); true))),
        u_on_backtrack( u_out( ";%n")),
        \+ tyi( 59), !,
        u_out( "%n").  

h_write_more_answers :-
        protein_flag( answers, all),
	protein_flag( search, Search),
	u_out( "%n"),	
	u_on_backtrack( h_retract), 
	(Search == id_tree -> u_on_backtrack( u_out("tree_depth "));
        (Search == id_inf  -> u_on_backtrack( u_out("inference maximum "));
	(Search == id_term -> u_on_backtrack( u_out("term depth ")); true))),
        u_on_backtrack( u_out( "%n")), 
        fail, !.

h_write_more_answers :- protein_flag( answers, one), !.

% END t_header.pl END

h_mmr.

%********************  t_header_info.pl  ********************

% Praedikate fuer Beweisstatistiken

%************************************************************

%%% h_write_trans_stat( S)
%%% Ausgabe der Uebersetzungsstatistik

:- mode h_write_trans_stat( ++).

h_write_trans_stat( S) :-
	nl( S),
	(protein_flag( reorder, off) -> true;
           getval( reorder, Reorder),
	   printf( S, "   Static Reorderings:    %5d%n", [Reorder])),
        (def_const( simplify, yes) -> 
	   getval( simplify, Simplify),
	   getval( sim_time, SimTime),
	   printf( S, "   Static Simplifications:%5d%n", [Simplify]),
           FSimTime is SimTime * 1.0,
           printf( S, "   Simplification Time:     %5.1f sec%n", [FSimTime])
        ; true),
	getval( taut, Taut),
        (Taut > 0 ->
           printf( S, "   Tautology Deletions:   %5d%n", [Taut]); true), !.


%%% p_count( GlobaleVariablenname)
%%% Bei jedem Schritt des Beweises wird entsprechend des Typs des Schritts
%%% eine globale Variable erhoeht. (Backtrackingfaehig)

:- mode p_count( ++).
	
p_count( Type) :- incval( Type), u_on_backtrack( decval( Type)). 


%%% h_init_stat
%%% Initialisierung der globalen Variablen fuer die Statistik 

h_init_stat :-
	setval( ext, 0),
	setval( red, 0),
	setval( red_cut, 0),
	setval( restart, 0),
	setval( factor, 0),
	setval( factor_cut, 0),
	setval( theory, 0),
        setval( inf, 0), 
	setval( proof_depth, 0),
	setval( proof_time, 0.0),
	setval( sim, 0),
	setval( sim_fail, 0),
	setval( sim_time, 0).


%%% h_write_stat( S)
%%% Schreibt Statistiken

:- mode h_write_stat( ++).

h_write_stat( S)  :-
	getval( ext, Ext),
	getval( red, Red_Nocut),
	getval( red_cut, Red_Cut),
	getval( restart, Restart),
	getval( factor, Factor_Nocut),
	getval( factor_cut, Factor_Cut),
	getval( sim, Sim),
	getval( sim_fail, SimFail),
	getval( theory, Theory),
	getval( inf, Inf),
        getval( proof_time, Proof_Time),
        (protein_flag( search, id_tree) -> 
	    getval( proof_depth, Proof_Depth); true),
	Red is Red_Nocut + Red_Cut,
	Factor is Factor_Nocut + Factor_Cut,
	nl( S),
	    printf( S, "   Proof Time:              %5.1f sec%n", [Proof_Time]),
        (protein_flag( search, id_tree) ->
            printf( S, "   Proof Depth:           %5d%n", [Proof_Depth]); true),
	(protein_result( proved) ->
            printf( S, "   Extension Steps:       %5d%n", [Ext]),
           (protein_flag( calculus, rme) ->
            printf( S, "   Restart Steps:         %5d%n", [Restart]); true),
            printf( S, "   Reduction Steps:       %5d", [Red]), 
           ((protein_flag( reduction, cut) ; 
             protein_flag( reduction, both)) ->
	    printf( S, " (incl.%6d with cut)%n", [Red_Cut]); nl(S)),
	    printf( S, "   Factoring Steps:       %5d", [Factor]),
           ((protein_flag( factorisation, cut) ; 
             protein_flag( factorisation, both)) ->
	    printf( S, " (incl.%6d with cut)%n", [Factor_Cut]); nl(S)),
	   (def_const( simplify, yes) ->
	    printf( S, "   Simplification Steps:  %5d", [Sim]),
           (SimFail > 0 ->
            printf( S, " (add.%7d forced failures)%n", [SimFail]); nl(S));true),
	   (def_const( theory, yes) ->
	    printf( S, "   Theory Steps:          %5d%n", [Theory]);true)
        ; true),
	    printf( S, "   Inferences:          %7d%n", [Inf]).


% ---------- Beweisinformationen schreiben ----------

%%% h_write_trc
%%% Schreibt die Beweisinfos in die Datei [Input-File-Name].trc

h_write_trc :-
	u_open_trc( S),
	printf( S,
        "%n------------------------ statistics ------------------------%n", []),
        h_write_trans_stat( S),
	h_write_stat( S),
	printf( S, 
       "%n------------------------- answers --------------------------%n", []),
        h_write_answers( S),
        close( S).

% END t_header_info.pl END

h_write_tree(_6777).

h_init_dynamic.

%********************  t_header_utils.pl ********************

% Utility-Praedikate, die waehrend des Beweisens gebraucht werden. 

%************************************************************

%%% p_unifiable( Element, List)
%%% Element unifizierbar mit einem Element der Liste? 

:- mode p_unifiable( +, +).

p_unifiable( El, [El|_]).
p_unifiable( El, [_,El|_]).
p_unifiable( El, [_,_,El|_]).
p_unifiable( El, [_,_,_|R]) :- p_unifiable( El, R).


%%% p_unifiable_n_count( Element, List, Index)
%%% Element unifizierbat mit dem wievielten Element der Liste?

:- mode p_unifiable_n_count( +, +, ?).

p_unifiable_n_count( El, [El|_], 1).
p_unifiable_n_count( El, [_,El|_], 2).
p_unifiable_n_count( El, [_,_,El|_], 3).

p_unifiable_n_count( El, [_,_,_|R], N) :-
	p_unifiable_n_count( El, R, M),
	N is M + 3.


%%% p_identical( Element, List)
%%% Element identisch eines Elements der Liste?

:- mode p_identical( +, +).

p_identical( El, [X|_])     :- El == X, !.
p_identical( El, [_,X|_])   :- El == X, !.
p_identical( El, [_,_,X|_]) :- El == X, !.
p_identical( El, [_,_,_|R]) :- p_identical( El, R), !.


%%% p_identical_n_count( Element, Liste, Index)
%%% Element identisch des wievielten Elements der Liste?

:- mode p_identical_n_count( +, +, -).

p_identical_n_count( El, [X|_], 1)     :- El == X, !.
p_identical_n_count( El, [_,X|_], 2)   :- El == X, !.
p_identical_n_count( El, [_,_,X|_], 3) :- El == X, !.

p_identical_n_count( El, [_,_,_|R], N) :- 
	p_identical_n_count( El, R, M), 
	N is M + 3, !.


%%% p_identical_upto_restart( Element, List)
%%% Element identisch eines Elements der Liste bis zum letzten Restart?

:- mode p_identical_upto_restart( +, +).

p_identical_upto_restart( _, [restart|_])       :- !, fail.
p_identical_upto_restart( El, [X|_])            :- El == X, !.
p_identical_upto_restart( _, [_,restart|_])     :- !, fail.
p_identical_upto_restart( El, [_,X|_])          :- El == X, !.
p_identical_upto_restart( _, [_,_,restart|_])   :- !, fail.
p_identical_upto_restart( El, [_,_,X|_])        :- El == X, !. 
p_identical_upto_restart( El, [_,_,_|R]) :- p_identical_upto_restart( El, R), !.


%%% p_never_identical( Element, Liste)
%%% Element nie identisch eines Elements der Liste?

:- mode p_never_identical( +, +).

p_never_identical( _, []).

p_never_identical( El, [X|R]) :-
	!, El ~= X,
        p_never_identical( El, R).


%%% p_never_identical_upto_restart( Element, AncL)
%%% Elememt nie identisch eines Elements der Liste bis zum letzten Restart?

:- mode p_never_identical_upto_restart( +, +).

p_never_identical_upto_restart( _, []).
p_never_identical_upto_restart( _, [restart|_]) :- !.

p_never_identical_upto_restart( El, [X|R]) :-
	!, El ~= X,
        p_never_identical_upto_restart( El, R).


%%% u_rewrite_list( Flag, SimLit, RewriteL, InCondL, InLitL, OutLitL, OutCondL)
%%% Wendet p_rewrite auf jedes Literal der InLitL an

:- mode u_rewrite_list( ++, +, +, +, ?, -, -).

u_rewrite_list( _, _, _, _, [], [], []) :- !.

u_rewrite_list( Flag, SimTerm, RewriteL, InCondL, [InTerm|InTermR], 
           [OutTerm|OutTermR], [OutCondL|OutCondR]) :- !,
        p_rewrite( Flag, SimTerm, RewriteL, InCondL, InTerm, 
                   OutTerm, OutCondL),
        u_rewrite_list( Flag, SimTerm, RewriteL, InCondL, InTermR, 
                   OutTermR, OutCondR).		   


%%% p_rewrite( Flag, SimLit, RewriteL, InCondL, InLit, OutLitL, OutCondL)
%%% Rewrite matchender Literale durch RewriteL

:- mode p_rewrite( ++, +, +, +, ?, ?, -).

p_rewrite( _, _, _, _, Var, [Var], []) :- var( Var), !.

p_rewrite( con, SimLit, RewriteL, InCondL, InLit, [OutLit], OutCondL) :-
	instance( InLit, SimLit), 
	copy_term( (SimLit,RewriteL,InCondL), (CSimLit,CRewriteL,OutCondL)),
	CSimLit = InLit, !,
	member( OutLit, CRewriteL).
	
p_rewrite( dis, SimLit, RewriteL, InCondL, InLit, CRewriteL, OutCondL) :- 
	instance( InLit, SimLit), 
	copy_term( (SimLit,RewriteL,InCondL), (CSimLit,CRewriteL,OutCondL)),
	CSimLit = InLit, !.

p_rewrite( rew, SimTerm, RewriteL, InCondL, InTerm, OutTermL, OutCondL) :- 
	InTerm =.. [Fnc|InArgL],
	u_rewrite_list( rew, SimTerm, RewriteL,InCondL,InArgL,ZwiArgL,ZwiCondL),
	u_flatten( ZwiArgL, OutArgL),
	ZwiTerm =.. [Fnc|OutArgL],
	p_rewrite( dis, SimTerm, RewriteL, InCondL, ZwiTerm, OutTermL,OutCondH),
	flatten( [OutCondH|ZwiCondL], OutCondL), !.

p_rewrite( flat, SimTerm, [Rewrite], InCondL, InTerm, [OutTerm], OutCondL) :- 
	InTerm =.. [Fnc|InArgL],
	l_rewrite_some( SimTerm, Rewrite,InCondL,InArgL,OutArgL,OutCondL),
	OutTerm =.. [Fnc|OutArgL],
	!.

p_rewrite( _, _, _, _, X, [X], []) :- !.


l_rewrite_some( SimTerm, Rewrite, InCondL, 
	        [Term|Rest], [CRewrite|Rest], OutCondL) :-
	instance( Term, SimTerm), 
	copy_term( (SimTerm,Rewrite,InCondL), (CSimTerm,CRewrite,OutCondL)),
	CSimTerm = Term, 
%	printf('Rewrite %w to %w, cond %w%n',[Term, CRewrite, OutCondL]),
	!.

l_rewrite_some( SimTerm, RewriteL, InCondL, 
	        [Term|Rest], [Term|SimRest], OutCondL) :-
	l_rewrite_some( SimTerm, RewriteL, InCondL, Rest, SimRest, OutCondL).


%%% p_assert_bck( Term)
%%% Backtrackingfaehiges append

:- mode p_assert_bck( +).

p_assert_bck( Term) :- assert( Term), u_on_backtrack( retract(Term)).


%%% p_count( GlobaleVariablenname, Additor)
%%% Backtrackingfaehiger Zaehler

:- mode p_count( ++, ++).
	
p_count( Type, Add) :- 
	getval( Type, Value),
	plus( Value, Add, Sum),
	setval( Type, Sum),
	u_on_backtrack( setval( Type, Value)). 


%%% p_call( Goal)
%%% Prologaufrufe, die nicht im Trace erscheinen

:- mode p_call( +).

p_call( Goal) :- Goal.


%%% u_on_backtrack( Goal)
%%% Ausfuehrung des Goals beim Backtracking

:- mode u_on_backtrack( +).

u_on_backtrack( _).
u_on_backtrack( Goal) :- Goal, !, fail. 


%%% u_flatten( InLL, OutL)
%%% Wie Flatten, jedoch nur ein Level

:- mode u_flatten( +, -).

u_flatten( [], []).

u_flatten( [H|InR], L) :-
	u_flatten( InR, OutR), 
	append( H, OutR, L).


%%% u_delay( Variable, Goal)
%%% Delayen des Goals bis Variable instanziiert wurde
%%% pragma( debug). erforderlich (to be able to see the DELAY port)

u_delay(Term, Goal, Module) :-
	make_suspension(Goal, 2, Susp, Module),
	insert_suspension(Term, Susp, 1, suspend).


%%% u_open_trc( S)
%%% Oeffnen des Tracefiles

:- mode u_open_trc( -).

u_open_trc( S) :-
	def_const( problem, Problem),
	concat_atoms( Problem, '.trc', FileN),
	open( FileN, append, S).


% ---------- Bildschirmmeldungen ----------

%%% u_out( String)
%%% u_out( String, VarL)
%%% Gibt Message auf dem Bildschirm aus

:- mode u_out( ++).
:- mode u_out( ++, +).

u_out( String) :- u_out( String, []).

u_out( String, VarL) :-
	protein_flag( out_stream, S),
	printf( S, String, VarL),
	flush( S).
	

% ---------- Start und Ende ----------

%%% u_init( Problem, OutProblem)
%%% Initialisierungen, Ausgabe Hinweise an den Benutzer

%:- mode u_init( ++, -).

u_init( InProblem, Problem) :-  
	name( InProblem, InProblemL),
	(append( ProblemL, [46,116,109,101], InProblemL) -> true ;
	    ProblemL = InProblemL),
	name( Problem, ProblemL),  
        set_error_handler(139,true/0),
	statistics( runtime, [Start,_]),
	def_set_const( start, Start),
	def_set_const( problem, Problem),
	set_flag( occur_check, on), 
	set_flag( print_depth, 1000000).

	
%%% u_tini
%%% Zuruecksetzen der Initialisierungen

u_tini :- 
	((protein_flag( trace, dynamic(_)), protein_mode( proof)) ->
           close( tview), 
	   close( input),
	   delete( in),
	   delete( out); true),
        (def_const( header, HeaderF),
	 exists( HeaderF) ->
	   concat_atoms( 'rm ', HeaderF, Call),
           sh( Call); true),
	def_const( problem, Problem),
	def_const( start, Start),
	statistics( runtime, [End,_]),
	Time is End - Start,
	Seconds is Time * 0.001,
	u_out( "%n%w.tme   finished in %w seconds%n", [Problem,Seconds]), !.
    

%%% u_abort
%%% Abort mit Zuruecksetzen der Initialisierungen

u_abort :- 
	u_out( "%naborting...", []),
	u_tini, 
	(protein_flag( out_stream, user) ->
	    halt ; exit_block( protein)).

% END t_header_utils.pl END

% ---------- Prolog Text ----------

p_neg_shortlit(pos, query, not_query).
p_neg_shortlit(neg, not_query, query).
p_neg_shortlit(pos, restart, not_restart).
p_neg_shortlit(neg, not_restart, restart).
p_neg_shortlit(pos, theory(A, B, C), not_theory(A, B, C)).
p_neg_shortlit(neg, not_theory(A, B, C), theory(A, B, C)).
p_neg_shortlit(pos, none, not_none).
p_neg_shortlit(neg, not_none, none).
p_neg_shortlit(pos, protein_prolog(A), protein_prolog(A)).
p_neg_shortlit(pos, protein_zarg(A, B), not_protein_zarg(A, B)).
p_neg_shortlit(neg, not_protein_zarg(A, B), protein_zarg(A, B)).
p_neg_shortlit(pos, dp_flag(A, B), not_dp_flag(A, B)).
p_neg_shortlit(neg, not_dp_flag(A, B), dp_flag(A, B)).
p_neg_shortlit(pos, m(A), not_m(A)).
p_neg_shortlit(neg, not_m(A), m(A)).
p_neg_shortlit(neg, not_ge2y(A), ge2y(A)).
p_neg_shortlit(pos, ge2y(A), not_ge2y(A)).
p_neg_shortlit(neg, not_ge2x(A), ge2x(A)).
p_neg_shortlit(pos, ge2x(A), not_ge2x(A)).
p_neg_shortlit(neg, not_p(A, B), p(A, B)).
p_neg_shortlit(pos, p(A, B), not_p(A, B)).
p_neg_shortlit(pos, y(A), not_y(A)).
p_neg_shortlit(neg, not_y(A), y(A)).
p_neg_shortlit(pos, x(A), not_x(A)).
p_neg_shortlit(neg, not_x(A), x(A)).
p_neg_shortlit(neg, not_s(A, B), s(A, B)).
p_neg_shortlit(pos, s(A, B), not_s(A, B)).
p_neg_shortlit(neg, not_c(A, B), c(A, B)).
p_neg_shortlit(pos, c(A, B), not_c(A, B)).
p_neg_shortlit(neg, not_cs(A, B, C, D), cs(A, B, C, D)).
p_neg_shortlit(pos, cs(A, B, C, D), not_cs(A, B, C, D)).
p_neg_shortlit(neg, not_ps(A, B, C, D), ps(A, B, C, D)).
p_neg_shortlit(pos, ps(A, B, C, D), not_ps(A, B, C, D)).
p_neg_shortlit(neg, not_pc(A, B, C, D), pc(A, B, C, D)).
p_neg_shortlit(pos, pc(A, B, C, D), not_pc(A, B, C, D)).


:- set_flag( variable_names, on).


% ---------- Control Predicates ----------

%%% h_start_proof( OutDepth, Trace)
%%% Starten des Beweises mit iterative deepening,
%%% dabei Ermitteln der Beweistiefe.

h_start_proof(A, B) :-
	h_search(query(C, D, ([], []), ([], []), '_*'), D, 1, 1, A).


%%% protein_answer( Answer)
%%% Speicherung der Antwortendurch Verzoegerung dieses Praedikates.

protein_answer(A) :-
	u_delay(true, protein_answer(A)).


% ---------- Additional Arguments ----------

p_zarg(reg, 4).
p_zarg(depth, 3).
p_zarg(ancs, 2).
p_zarg(aunts, 1).
p_zarg(check, 0).


% ---------- Constants ----------

def_const(problem, test).
def_const(titel, "********************    PROTEIN V2.33   ********************").
def_const(theory, no).
def_const(simplify, no).


% ---------- Flags ----------

protein_flag(ancestry_rme, off).
protein_flag(ancs, both).
protein_flag(answers, one).
protein_flag(answer_set_handling, on).
protein_flag(calculus, me).
protein_flag(check_flags, []).
protein_flag(ctest, now).
protein_flag(definite_answers, off).
protein_flag(delayed_rme, off).
protein_flag(depth_increment, 1).
protein_flag(dynamic, off).
protein_flag(ec_pruning, off).
protein_flag(factorisation, cut).
protein_flag(rewrite, flat).
protein_flag(head_behind_prolog, off).
protein_flag(max_rew_cond, 0).
protein_flag(mmr, off).
protein_flag(mode, pl1).
protein_flag(out_stream, user).
protein_flag(query_reuse, on).
protein_flag(reduction, both).
protein_flag(regularity, delay).
protein_flag(reorder, off).
protein_flag(search, id_tree).
protein_flag(selection_function, off).
protein_flag(sim_dynamic, nocut).
protein_flag(sim_static, uncond).
protein_flag(sim_deletion, complete).
protein_flag(sim_focus, query).
protein_flag(sorting, costs).
protein_flag(strict_rme, off).
protein_flag(th_nonewclauses, off).
protein_flag(th_reduction, both).
protein_flag(th_regularity, delay).
protein_flag(th_sidelit_anc, off).
protein_flag(timeout, 0).
protein_flag(trace, info).
protein_flag(translate, all).
protein_flag(count, off).


% ---------- Predicates ----------

query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	ge2y(0, r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	ge2x(0, r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(0))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(0)))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(0))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(0)))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(i(0))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(i(i(0)))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(i(i(i(0))))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(i(i(i(i(0)))))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(i(i(i(i(i(0))))))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(i(i(i(i(i(i(0)))))))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	m(i(i(i(i(i(i(i(i(i(i(i(i(F)))))))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	y(i(i(i(i(i(i(i(i(i(i(i(i(F)))))))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	x(i(i(i(i(i(i(i(i(i(i(i(i(F)))))))))))), r, E, ([query|B], C), D, '_*').
query(n, A, (B, C), (D, E), '_*') :-
	(
	    A >= 1
	->
	    plus(F, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	p(0, i(G), r, F, ([query|B], C), (D, E), '_*'),
	p(i(G), 0, r, F, ([query|B], C), ([p(0, i(G))|D], E), '_*'),
	s(0, G, r, F, ([query|B], C), ([p(i(G), 0), p(0, i(G))|D], E), '_*').
protein_prolog(A, B, C, D, E, '_*') :-
	A.
protein_zarg(reg, A, A, B, C, D, '_*').
protein_zarg(depth, A, B, A, C, D, '_*').
protein_zarg(ancs, A, B, C, A, D, '_*').
protein_zarg(aunts, A, B, C, D, A, '_*').
protein_zarg(check, '_*', A, B, C, D, '_*').
dp_flag(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(dp_flag(A, B), D),
	dp_flag(A, B, n, C, (D, E), F, '_*').
dp_flag(A, B, n, C, (D, E), F, '_*') :-
	p_identical(not_dp_flag(A, B), E),
	!,
	incval(inf),
	p_count(red_cut).
dp_flag(A, B, n, C, D, (E, F), '_*') :-
	p_identical(dp_flag(A, B), E),
	!,
	incval(inf),
	p_count(factor_cut).
dp_flag(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(not_dp_flag(A, B), E),
	incval(inf),
	p_count(red).
dp_flag(initial_interpretation, [-(A)], n, B, C, D, '_*') :-
	incval(inf),
	p_count(ext).
not_dp_flag(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(not_dp_flag(A, B), E),
	not_dp_flag(A, B, n, C, (D, E), F, '_*').
not_dp_flag(A, B, n, C, (D, E), F, '_*') :-
	p_identical(dp_flag(A, B), D),
	!,
	incval(inf),
	p_count(red_cut).
not_dp_flag(A, B, n, C, D, (E, F), '_*') :-
	p_identical(not_dp_flag(A, B), F),
	!,
	incval(inf),
	p_count(factor_cut).
not_dp_flag(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(dp_flag(A, B), D),
	incval(inf),
	p_count(red).
m(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(m(A), C),
	m(A, n, B, (C, D), E, '_*').
m(A, n, B, (C, D), E, '_*') :-
	p_identical(not_m(A), D),
	!,
	incval(inf),
	p_count(red_cut).
m(A, n, B, C, (D, E), '_*') :-
	p_identical(m(A), D),
	!,
	incval(inf),
	p_count(factor_cut).
m(A, n, B, (C, D), E, '_*') :-
	p_unifiable(not_m(A), D),
	incval(inf),
	p_count(red).
m(0, n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
m(i(0), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
m(i(i(0)), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
m(0, n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(0, 0, r, E, ([m(0)|B], C), D, '_*'),
	p_count(ext).
m(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	s(A, 0, r, F, ([m(i(A))|C], D), E, '_*'),
	p_count(ext).
not_m(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(not_m(A), D),
	not_m(A, n, B, (C, D), E, '_*').
not_m(A, n, B, (C, D), E, '_*') :-
	p_identical(m(A), C),
	!,
	incval(inf),
	p_count(red_cut).
not_m(A, n, B, C, (D, E), '_*') :-
	p_identical(not_m(A), E),
	!,
	incval(inf),
	p_count(factor_cut).
not_m(A, n, B, (C, D), E, '_*') :-
	p_unifiable(m(A), C),
	incval(inf),
	p_count(red).
not_m(i(i(i(0))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(0)))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(0))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(0)))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(i(0))))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(i(i(0)))))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(i(i(i(0))))))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(i(i(i(i(0)))))))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(i(i(i(i(i(0))))))))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(i(i(i(i(i(i(0)))))))))))), n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_m(i(i(i(i(i(i(i(i(i(i(i(i(A)))))))))))), n, B, C, D, '_*') :-
	incval(inf),
	p_count(ext).
not_m(0, n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(0, 0, r, E, (B, [not_m(0)|C]), D, '_*'),
	p_count(ext).
not_m(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(A, 0, r, F, (C, [not_m(i(A))|D]), E, '_*'),
	p_count(ext).
not_ge2y(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(not_ge2y(A), D),
	not_ge2y(A, n, B, (C, D), E, '_*').
not_ge2y(A, n, B, (C, D), E, '_*') :-
	p_identical(ge2y(A), C),
	!,
	incval(inf),
	p_count(red_cut).
not_ge2y(A, n, B, C, (D, E), '_*') :-
	p_identical(not_ge2y(A), E),
	!,
	incval(inf),
	p_count(factor_cut).
not_ge2y(A, n, B, (C, D), E, '_*') :-
	p_unifiable(ge2y(A), C),
	incval(inf),
	p_count(red).
not_ge2y(0, n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_ge2y(A, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ge2y(i(A), r, F, (C, [not_ge2y(A)|D]), E, '_*'),
	p_count(ext).
not_ge2y(i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_y(i(A), r, G, (C, [not_ge2y(i(A))|D]), (E, F), '_*'),
	not_ge2y(A, r, G, (C, [not_ge2y(i(A))|D]), (E, [not_y(i(A))|F]), '_*'),
	p_count(ext).
ge2y(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(ge2y(A), C),
	ge2y(A, n, B, (C, D), E, '_*').
ge2y(A, n, B, (C, D), E, '_*') :-
	p_identical(not_ge2y(A), D),
	!,
	incval(inf),
	p_count(red_cut).
ge2y(A, n, B, C, (D, E), '_*') :-
	p_identical(ge2y(A), D),
	!,
	incval(inf),
	p_count(factor_cut).
ge2y(A, n, B, (C, D), E, '_*') :-
	p_unifiable(not_ge2y(A), D),
	incval(inf),
	p_count(red).
ge2y(i(i(i(i(i(i(i(i(i(i(i(A))))))))))), n, B, C, D, '_*') :-
	incval(inf),
	p_count(ext).
ge2y(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	ge2y(A, r, F, ([ge2y(i(A))|C], D), E, '_*'),
	p_count(ext).
ge2y(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	y(i(A), r, F, ([ge2y(i(A))|C], D), E, '_*'),
	p_count(ext).
ge2y(A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_y(i(A), r, G, ([ge2y(A)|C], D), (E, F), '_*'),
	ge2y(i(A), r, G, ([ge2y(A)|C], D), (E, [not_y(i(A))|F]), '_*'),
	p_count(ext).
not_ge2x(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(not_ge2x(A), D),
	not_ge2x(A, n, B, (C, D), E, '_*').
not_ge2x(A, n, B, (C, D), E, '_*') :-
	p_identical(ge2x(A), C),
	!,
	incval(inf),
	p_count(red_cut).
not_ge2x(A, n, B, C, (D, E), '_*') :-
	p_identical(not_ge2x(A), E),
	!,
	incval(inf),
	p_count(factor_cut).
not_ge2x(A, n, B, (C, D), E, '_*') :-
	p_unifiable(ge2x(A), C),
	incval(inf),
	p_count(red).
not_ge2x(0, n, A, B, C, '_*') :-
	incval(inf),
	p_count(ext).
not_ge2x(A, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ge2x(i(A), r, F, (C, [not_ge2x(A)|D]), E, '_*'),
	p_count(ext).
not_ge2x(i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_x(i(A), r, G, (C, [not_ge2x(i(A))|D]), (E, F), '_*'),
	not_ge2x(A, r, G, (C, [not_ge2x(i(A))|D]), (E, [not_x(i(A))|F]), '_*'),
	p_count(ext).
ge2x(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(ge2x(A), C),
	ge2x(A, n, B, (C, D), E, '_*').
ge2x(A, n, B, (C, D), E, '_*') :-
	p_identical(not_ge2x(A), D),
	!,
	incval(inf),
	p_count(red_cut).
ge2x(A, n, B, C, (D, E), '_*') :-
	p_identical(ge2x(A), D),
	!,
	incval(inf),
	p_count(factor_cut).
ge2x(A, n, B, (C, D), E, '_*') :-
	p_unifiable(not_ge2x(A), D),
	incval(inf),
	p_count(red).
ge2x(i(i(i(i(i(i(i(i(i(i(i(A))))))))))), n, B, C, D, '_*') :-
	incval(inf),
	p_count(ext).
ge2x(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	ge2x(A, r, F, ([ge2x(i(A))|C], D), E, '_*'),
	p_count(ext).
ge2x(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	x(i(A), r, F, ([ge2x(i(A))|C], D), E, '_*'),
	p_count(ext).
ge2x(A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_x(i(A), r, G, ([ge2x(A)|C], D), (E, F), '_*'),
	ge2x(i(A), r, G, ([ge2x(A)|C], D), (E, [not_x(i(A))|F]), '_*'),
	p_count(ext).
not_p(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(not_p(A, B), E),
	not_p(A, B, n, C, (D, E), F, '_*').
not_p(A, B, n, C, (D, E), F, '_*') :-
	p_identical(p(A, B), D),
	!,
	incval(inf),
	p_count(red_cut).
not_p(A, B, n, C, D, (E, F), '_*') :-
	p_identical(not_p(A, B), F),
	!,
	incval(inf),
	p_count(factor_cut).
not_p(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(p(A, B), D),
	incval(inf),
	p_count(red).
not_p(0, 0, n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_m(0, r, E, (B, [not_p(0, 0)|C]), D, '_*'),
	p_count(ext).
not_p(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_y(B, r, G, (D, [not_p(A, B)|E]), F, '_*'),
	p_count(ext).
not_p(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_x(A, r, G, (D, [not_p(A, B)|E]), F, '_*'),
	p_count(ext).
not_p(i(A), 0, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(0, i(A), r, G, (C, [not_p(i(A), 0)|D]), (E, F), '_*'),
	not_s(0, A, r, G, (C, [not_p(i(A), 0)|D]), (E, [not_p(0, i(A))|F]), '_*'),
	p_count(ext).
not_p(0, i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(A), 0, r, G, (C, [not_p(0, i(A))|D]), (E, F), '_*'),
	not_s(0, A, r, G, (C, [not_p(0, i(A))|D]), (E, [not_p(i(A), 0)|F]), '_*'),
	p_count(ext).
not_p(0, i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(0, A, r, G, (C, [not_p(0, i(A))|D]), (E, F), '_*'),
	p(i(A), 0, r, G, (C, [not_p(0, i(A))|D]), (E, [not_c(0, A)|F]), '_*'),
	p_count(ext).
not_p(i(A), 0, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(0, A, r, G, (C, [not_p(i(A), 0)|D]), (E, F), '_*'),
	p(0, i(A), r, G, (C, [not_p(i(A), 0)|D]), (E, [not_c(0, A)|F]), '_*'),
	p_count(ext).
not_p(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ps(A, B, I, J, r, H, (D, [not_p(A, B)|E]), (F, G), '_*'),
	s(I, J, r, H, (D, [not_p(A, B)|E]), (F, [not_ps(A, B, I, J)|G]), '_*'),
	p_count(ext).
not_p(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_pc(A, B, I, J, r, H, (D, [not_p(A, B)|E]), (F, G), '_*'),
	c(I, J, r, H, (D, [not_p(A, B)|E]), (F, [not_pc(A, B, I, J)|G]), '_*'),
	p_count(ext).
not_p(0, i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(i(A), 0, r, G, (C, [not_p(0, i(A))|D]), (E, F), '_*'),
	s(0, A, r, G, (C, [not_p(0, i(A))|D]), ([p(i(A), 0)|E], F), '_*'),
	p_count(ext).
not_p(i(A), 0, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(0, i(A), r, G, (C, [not_p(i(A), 0)|D]), (E, F), '_*'),
	s(0, A, r, G, (C, [not_p(i(A), 0)|D]), ([p(0, i(A))|E], F), '_*'),
	p_count(ext).
not_p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(B, i(A), r, H, (D, [not_p(i(A), i(B))|E]), (F, G), '_*'),
	not_c(B, A, r, H, (D, [not_p(i(A), i(B))|E]), (F, [not_s(B, i(A))|G]), '_*'),
	not_s(i(B), A, r, H, (D, [not_p(i(A), i(B))|E]), (F, [not_c(B, A), not_s(B, i(A))|G]), '_*'),
	p_count(ext).
not_p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(B, A, r, H, (D, [not_p(i(A), i(B))|E]), (F, G), '_*'),
	s(B, i(A), r, H, (D, [not_p(i(A), i(B))|E]), (F, [not_c(B, A)|G]), '_*'),
	s(i(B), A, r, H, (D, [not_p(i(A), i(B))|E]), ([s(B, i(A))|F], [not_c(B, A)|G]), '_*'),
	p_count(ext).
not_p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(B, i(A), r, H, (D, [not_p(i(A), i(B))|E]), (F, G), '_*'),
	c(B, A, r, H, (D, [not_p(i(A), i(B))|E]), (F, [not_s(B, i(A))|G]), '_*'),
	s(i(B), A, r, H, (D, [not_p(i(A), i(B))|E]), ([c(B, A)|F], [not_s(B, i(A))|G]), '_*'),
	p_count(ext).
not_p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(i(B), A, r, H, (D, [not_p(i(A), i(B))|E]), (F, G), '_*'),
	s(B, i(A), r, H, (D, [not_p(i(A), i(B))|E]), (F, [not_s(i(B), A)|G]), '_*'),
	c(B, A, r, H, (D, [not_p(i(A), i(B))|E]), ([s(B, i(A))|F], [not_s(i(B), A)|G]), '_*'),
	p_count(ext).
p(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(p(A, B), D),
	p(A, B, n, C, (D, E), F, '_*').
p(A, B, n, C, (D, E), F, '_*') :-
	p_identical(not_p(A, B), E),
	!,
	incval(inf),
	p_count(red_cut).
p(A, B, n, C, D, (E, F), '_*') :-
	p_identical(p(A, B), E),
	!,
	incval(inf),
	p_count(factor_cut).
p(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(not_p(A, B), E),
	incval(inf),
	p_count(red).
p(0, 0, n, A, (B, C), D, '_*') :-
	(
	    A >= 1
	->
	    plus(E, 1, A)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	m(0, r, E, ([p(0, 0)|B], C), D, '_*'),
	p_count(ext).
p(i(A), 0, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	c(0, A, r, F, ([p(i(A), 0)|C], D), E, '_*'),
	p_count(ext).
p(0, i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	c(0, A, r, F, ([p(0, i(A))|C], D), E, '_*'),
	p_count(ext).
p(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	ps(A, B, H, I, r, G, ([p(A, B)|D], E), F, '_*'),
	p_count(ext).
p(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	pc(A, B, H, I, r, G, ([p(A, B)|D], E), F, '_*'),
	p_count(ext).
p(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	y(B, r, H, ([p(A, B)|D], E), (F, G), '_*'),
	x(A, r, H, ([p(A, B)|D], E), ([y(B)|F], G), '_*'),
	p_count(ext).
p(i(A), 0, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(0, i(A), r, G, ([p(i(A), 0)|C], D), (E, F), '_*'),
	s(0, A, r, G, ([p(i(A), 0)|C], D), (E, [not_p(0, i(A))|F]), '_*'),
	p_count(ext).
p(0, i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(A), 0, r, G, ([p(0, i(A))|C], D), (E, F), '_*'),
	s(0, A, r, G, ([p(0, i(A))|C], D), (E, [not_p(i(A), 0)|F]), '_*'),
	p_count(ext).
p(0, i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(0, A, r, G, ([p(0, i(A))|C], D), (E, F), '_*'),
	p(i(A), 0, r, G, ([p(0, i(A))|C], D), (E, [not_s(0, A)|F]), '_*'),
	p_count(ext).
p(i(A), 0, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(0, A, r, G, ([p(i(A), 0)|C], D), (E, F), '_*'),
	p(0, i(A), r, G, ([p(i(A), 0)|C], D), (E, [not_s(0, A)|F]), '_*'),
	p_count(ext).
p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(B, i(A), r, H, ([p(i(A), i(B))|D], E), (F, G), '_*'),
	not_c(B, A, r, H, ([p(i(A), i(B))|D], E), (F, [not_s(B, i(A))|G]), '_*'),
	s(i(B), A, r, H, ([p(i(A), i(B))|D], E), (F, [not_c(B, A), not_s(B, i(A))|G]), '_*'),
	p_count(ext).
p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(B, i(A), r, H, ([p(i(A), i(B))|D], E), (F, G), '_*'),
	not_s(i(B), A, r, H, ([p(i(A), i(B))|D], E), (F, [not_s(B, i(A))|G]), '_*'),
	c(B, A, r, H, ([p(i(A), i(B))|D], E), (F, [not_s(i(B), A), not_s(B, i(A))|G]), '_*'),
	p_count(ext).
p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(B, A, r, H, ([p(i(A), i(B))|D], E), (F, G), '_*'),
	not_s(i(B), A, r, H, ([p(i(A), i(B))|D], E), (F, [not_c(B, A)|G]), '_*'),
	s(B, i(A), r, H, ([p(i(A), i(B))|D], E), (F, [not_s(i(B), A), not_c(B, A)|G]), '_*'),
	p_count(ext).
p(i(A), i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	s(B, i(A), r, H, ([p(i(A), i(B))|D], E), (F, G), '_*'),
	c(B, A, r, H, ([p(i(A), i(B))|D], E), ([s(B, i(A))|F], G), '_*'),
	s(i(B), A, r, H, ([p(i(A), i(B))|D], E), ([c(B, A), s(B, i(A))|F], G), '_*'),
	p_count(ext).
y(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(y(A), C),
	y(A, n, B, (C, D), E, '_*').
y(A, n, B, (C, D), E, '_*') :-
	p_identical(not_y(A), D),
	!,
	incval(inf),
	p_count(red_cut).
y(A, n, B, C, (D, E), '_*') :-
	p_identical(y(A), D),
	!,
	incval(inf),
	p_count(factor_cut).
y(A, n, B, (C, D), E, '_*') :-
	p_unifiable(not_y(A), D),
	incval(inf),
	p_count(red).
y(A, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(G, A, r, F, ([y(A)|C], D), E, '_*'),
	p_count(ext).
y(i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ge2y(A, r, G, ([y(i(A))|C], D), (E, F), '_*'),
	ge2y(i(A), r, G, ([y(i(A))|C], D), (E, [not_ge2y(A)|F]), '_*'),
	p_count(ext).
not_y(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(not_y(A), D),
	not_y(A, n, B, (C, D), E, '_*').
not_y(A, n, B, (C, D), E, '_*') :-
	p_identical(y(A), C),
	!,
	incval(inf),
	p_count(red_cut).
not_y(A, n, B, C, (D, E), '_*') :-
	p_identical(not_y(A), E),
	!,
	incval(inf),
	p_count(factor_cut).
not_y(A, n, B, (C, D), E, '_*') :-
	p_unifiable(y(A), C),
	incval(inf),
	p_count(red).
not_y(i(i(i(i(i(i(i(i(i(i(i(i(A)))))))))))), n, B, C, D, '_*') :-
	incval(inf),
	p_count(ext).
not_y(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ge2y(i(A), r, F, (C, [not_y(i(A))|D]), E, '_*'),
	p_count(ext).
not_y(A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(H, A, r, G, (C, [not_y(A)|D]), (E, F), '_*'),
	x(H, r, G, (C, [not_y(A)|D]), (E, [not_p(H, A)|F]), '_*'),
	p_count(ext).
x(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(x(A), C),
	x(A, n, B, (C, D), E, '_*').
x(A, n, B, (C, D), E, '_*') :-
	p_identical(not_x(A), D),
	!,
	incval(inf),
	p_count(red_cut).
x(A, n, B, C, (D, E), '_*') :-
	p_identical(x(A), D),
	!,
	incval(inf),
	p_count(factor_cut).
x(A, n, B, (C, D), E, '_*') :-
	p_unifiable(not_x(A), D),
	incval(inf),
	p_count(red).
x(A, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(A, G, r, F, ([x(A)|C], D), E, '_*'),
	p_count(ext).
x(i(A), n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ge2x(A, r, G, ([x(i(A))|C], D), (E, F), '_*'),
	ge2x(i(A), r, G, ([x(i(A))|C], D), (E, [not_ge2x(A)|F]), '_*'),
	p_count(ext).
not_x(A, r, B, (C, D), E, '_*') :-
	!,
	p_never_identical(not_x(A), D),
	not_x(A, n, B, (C, D), E, '_*').
not_x(A, n, B, (C, D), E, '_*') :-
	p_identical(x(A), C),
	!,
	incval(inf),
	p_count(red_cut).
not_x(A, n, B, C, (D, E), '_*') :-
	p_identical(not_x(A), E),
	!,
	incval(inf),
	p_count(factor_cut).
not_x(A, n, B, (C, D), E, '_*') :-
	p_unifiable(x(A), C),
	incval(inf),
	p_count(red).
not_x(i(i(i(i(i(i(i(i(i(i(i(i(A)))))))))))), n, B, C, D, '_*') :-
	incval(inf),
	p_count(ext).
not_x(i(A), n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ge2x(i(A), r, F, (C, [not_x(i(A))|D]), E, '_*'),
	p_count(ext).
not_x(A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(A, H, r, G, (C, [not_x(A)|D]), (E, F), '_*'),
	y(H, r, G, (C, [not_x(A)|D]), (E, [not_p(A, H)|F]), '_*'),
	p_count(ext).
not_s(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(not_s(A, B), E),
	not_s(A, B, n, C, (D, E), F, '_*').
not_s(A, B, n, C, (D, E), F, '_*') :-
	p_identical(s(A, B), D),
	!,
	incval(inf),
	p_count(red_cut).
not_s(A, B, n, C, D, (E, F), '_*') :-
	p_identical(not_s(A, B), F),
	!,
	incval(inf),
	p_count(factor_cut).
not_s(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(s(A, B), D),
	incval(inf),
	p_count(red).
not_s(A, 0, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_m(i(A), r, F, (C, [not_s(A, 0)|D]), E, '_*'),
	p_count(ext).
not_s(0, A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(A), 0, r, G, (C, [not_s(0, A)|D]), (E, F), '_*'),
	not_p(0, i(A), r, G, (C, [not_s(0, A)|D]), (E, [not_p(i(A), 0)|F]), '_*'),
	p_count(ext).
not_s(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_cs(I, J, A, B, r, H, (D, [not_s(A, B)|E]), (F, G), '_*'),
	c(I, J, r, H, (D, [not_s(A, B)|E]), (F, [not_cs(I, J, A, B)|G]), '_*'),
	p_count(ext).
not_s(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ps(I, J, A, B, r, H, (D, [not_s(A, B)|E]), (F, G), '_*'),
	p(I, J, r, H, (D, [not_s(A, B)|E]), (F, [not_ps(I, J, A, B)|G]), '_*'),
	p_count(ext).
not_s(0, A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(0, i(A), r, G, (C, [not_s(0, A)|D]), (E, F), '_*'),
	p(i(A), 0, r, G, (C, [not_s(0, A)|D]), ([p(0, i(A))|E], F), '_*'),
	p_count(ext).
not_s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, (D, [not_s(i(A), B)|E]), (F, G), '_*'),
	not_s(A, i(B), r, H, (D, [not_s(i(A), B)|E]), (F, [not_p(i(B), i(A))|G]), '_*'),
	not_c(A, B, r, H, (D, [not_s(i(A), B)|E]), (F, [not_s(A, i(B)), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
not_s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, (D, [not_s(A, i(B))|E]), (F, G), '_*'),
	not_c(A, B, r, H, (D, [not_s(A, i(B))|E]), (F, [not_p(i(B), i(A))|G]), '_*'),
	not_s(i(A), B, r, H, (D, [not_s(A, i(B))|E]), (F, [not_c(A, B), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
not_s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(A, B, r, H, (D, [not_s(A, i(B))|E]), (F, G), '_*'),
	p(i(B), i(A), r, H, (D, [not_s(A, i(B))|E]), (F, [not_c(A, B)|G]), '_*'),
	s(i(A), B, r, H, (D, [not_s(A, i(B))|E]), ([p(i(B), i(A))|F], [not_c(A, B)|G]), '_*'),
	p_count(ext).
not_s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(A, B, r, H, (D, [not_s(i(A), B)|E]), (F, G), '_*'),
	s(A, i(B), r, H, (D, [not_s(i(A), B)|E]), (F, [not_c(A, B)|G]), '_*'),
	p(i(B), i(A), r, H, (D, [not_s(i(A), B)|E]), ([s(A, i(B))|F], [not_c(A, B)|G]), '_*'),
	p_count(ext).
not_s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, (D, [not_s(A, i(B))|E]), (F, G), '_*'),
	c(A, B, r, H, (D, [not_s(A, i(B))|E]), (F, [not_p(i(B), i(A))|G]), '_*'),
	s(i(A), B, r, H, (D, [not_s(A, i(B))|E]), ([c(A, B)|F], [not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
not_s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, (D, [not_s(i(A), B)|E]), (F, G), '_*'),
	s(A, i(B), r, H, (D, [not_s(i(A), B)|E]), (F, [not_p(i(B), i(A))|G]), '_*'),
	c(A, B, r, H, (D, [not_s(i(A), B)|E]), ([s(A, i(B))|F], [not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
not_s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(A, i(B), r, H, (D, [not_s(i(A), B)|E]), (F, G), '_*'),
	p(i(B), i(A), r, H, (D, [not_s(i(A), B)|E]), (F, [not_s(A, i(B))|G]), '_*'),
	c(A, B, r, H, (D, [not_s(i(A), B)|E]), ([p(i(B), i(A))|F], [not_s(A, i(B))|G]), '_*'),
	p_count(ext).
not_s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(i(A), B, r, H, (D, [not_s(A, i(B))|E]), (F, G), '_*'),
	p(i(B), i(A), r, H, (D, [not_s(A, i(B))|E]), (F, [not_s(i(A), B)|G]), '_*'),
	c(A, B, r, H, (D, [not_s(A, i(B))|E]), ([p(i(B), i(A))|F], [not_s(i(A), B)|G]), '_*'),
	p_count(ext).
s(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(s(A, B), D),
	s(A, B, n, C, (D, E), F, '_*').
s(A, B, n, C, (D, E), F, '_*') :-
	p_identical(not_s(A, B), E),
	!,
	incval(inf),
	p_count(red_cut).
s(A, B, n, C, D, (E, F), '_*') :-
	p_identical(s(A, B), E),
	!,
	incval(inf),
	p_count(factor_cut).
s(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(not_s(A, B), E),
	incval(inf),
	p_count(red).
s(A, 0, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	m(i(A), r, F, ([s(A, 0)|C], D), E, '_*'),
	p_count(ext).
s(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	cs(H, I, A, B, r, G, ([s(A, B)|D], E), F, '_*'),
	p_count(ext).
s(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	ps(H, I, A, B, r, G, ([s(A, B)|D], E), F, '_*'),
	p_count(ext).
s(0, A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(0, i(A), r, G, ([s(0, A)|C], D), (E, F), '_*'),
	p(i(A), 0, r, G, ([s(0, A)|C], D), (E, [not_p(0, i(A))|F]), '_*'),
	p_count(ext).
s(0, A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(A), 0, r, G, ([s(0, A)|C], D), (E, F), '_*'),
	p(0, i(A), r, G, ([s(0, A)|C], D), (E, [not_p(i(A), 0)|F]), '_*'),
	p_count(ext).
s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, ([s(A, i(B))|D], E), (F, G), '_*'),
	not_c(A, B, r, H, ([s(A, i(B))|D], E), (F, [not_p(i(B), i(A))|G]), '_*'),
	s(i(A), B, r, H, ([s(A, i(B))|D], E), (F, [not_c(A, B), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, ([s(A, i(B))|D], E), (F, G), '_*'),
	not_s(i(A), B, r, H, ([s(A, i(B))|D], E), (F, [not_p(i(B), i(A))|G]), '_*'),
	c(A, B, r, H, ([s(A, i(B))|D], E), (F, [not_s(i(A), B), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, ([s(i(A), B)|D], E), (F, G), '_*'),
	not_s(A, i(B), r, H, ([s(i(A), B)|D], E), (F, [not_p(i(B), i(A))|G]), '_*'),
	c(A, B, r, H, ([s(i(A), B)|D], E), (F, [not_s(A, i(B)), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(A, B, r, H, ([s(A, i(B))|D], E), (F, G), '_*'),
	not_s(i(A), B, r, H, ([s(A, i(B))|D], E), (F, [not_c(A, B)|G]), '_*'),
	p(i(B), i(A), r, H, ([s(A, i(B))|D], E), (F, [not_s(i(A), B), not_c(A, B)|G]), '_*'),
	p_count(ext).
s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(A, i(B), r, H, ([s(i(A), B)|D], E), (F, G), '_*'),
	not_c(A, B, r, H, ([s(i(A), B)|D], E), (F, [not_s(A, i(B))|G]), '_*'),
	p(i(B), i(A), r, H, ([s(i(A), B)|D], E), (F, [not_c(A, B), not_s(A, i(B))|G]), '_*'),
	p_count(ext).
s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, ([s(i(A), B)|D], E), (F, G), '_*'),
	not_c(A, B, r, H, ([s(i(A), B)|D], E), (F, [not_p(i(B), i(A))|G]), '_*'),
	s(A, i(B), r, H, ([s(i(A), B)|D], E), (F, [not_c(A, B), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
s(A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(i(B), i(A), r, H, ([s(A, i(B))|D], E), (F, G), '_*'),
	c(A, B, r, H, ([s(A, i(B))|D], E), ([p(i(B), i(A))|F], G), '_*'),
	s(i(A), B, r, H, ([s(A, i(B))|D], E), ([c(A, B), p(i(B), i(A))|F], G), '_*'),
	p_count(ext).
s(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	s(A, i(B), r, H, ([s(i(A), B)|D], E), (F, G), '_*'),
	p(i(B), i(A), r, H, ([s(i(A), B)|D], E), ([s(A, i(B))|F], G), '_*'),
	c(A, B, r, H, ([s(i(A), B)|D], E), ([p(i(B), i(A)), s(A, i(B))|F], G), '_*'),
	p_count(ext).
not_c(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(not_c(A, B), E),
	not_c(A, B, n, C, (D, E), F, '_*').
not_c(A, B, n, C, (D, E), F, '_*') :-
	p_identical(c(A, B), D),
	!,
	incval(inf),
	p_count(red_cut).
not_c(A, B, n, C, D, (E, F), '_*') :-
	p_identical(not_c(A, B), F),
	!,
	incval(inf),
	p_count(factor_cut).
not_c(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(c(A, B), D),
	incval(inf),
	p_count(red).
not_c(0, A, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(A), 0, r, F, (C, [not_c(0, A)|D]), E, '_*'),
	p_count(ext).
not_c(0, A, n, B, (C, D), E, '_*') :-
	(
	    B >= 1
	->
	    plus(F, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(0, i(A), r, F, (C, [not_c(0, A)|D]), E, '_*'),
	p_count(ext).
not_c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_cs(A, B, I, J, r, H, (D, [not_c(A, B)|E]), (F, G), '_*'),
	s(I, J, r, H, (D, [not_c(A, B)|E]), (F, [not_cs(A, B, I, J)|G]), '_*'),
	p_count(ext).
not_c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_pc(I, J, A, B, r, H, (D, [not_c(A, B)|E]), (F, G), '_*'),
	p(I, J, r, H, (D, [not_c(A, B)|E]), (F, [not_pc(I, J, A, B)|G]), '_*'),
	p_count(ext).
not_c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, (D, [not_c(A, B)|E]), (F, G), '_*'),
	not_s(A, i(B), r, H, (D, [not_c(A, B)|E]), (F, [not_p(i(B), i(A))|G]), '_*'),
	not_s(i(A), B, r, H, (D, [not_c(A, B)|E]), (F, [not_s(A, i(B)), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
not_c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, (D, [not_c(A, B)|E]), (F, G), '_*'),
	s(A, i(B), r, H, (D, [not_c(A, B)|E]), (F, [not_p(i(B), i(A))|G]), '_*'),
	s(i(A), B, r, H, (D, [not_c(A, B)|E]), ([s(A, i(B))|F], [not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
not_c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(A, i(B), r, H, (D, [not_c(A, B)|E]), (F, G), '_*'),
	p(i(B), i(A), r, H, (D, [not_c(A, B)|E]), (F, [not_s(A, i(B))|G]), '_*'),
	s(i(A), B, r, H, (D, [not_c(A, B)|E]), ([p(i(B), i(A))|F], [not_s(A, i(B))|G]), '_*'),
	p_count(ext).
not_c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(i(A), B, r, H, (D, [not_c(A, B)|E]), (F, G), '_*'),
	s(A, i(B), r, H, (D, [not_c(A, B)|E]), (F, [not_s(i(A), B)|G]), '_*'),
	p(i(B), i(A), r, H, (D, [not_c(A, B)|E]), ([s(A, i(B))|F], [not_s(i(A), B)|G]), '_*'),
	p_count(ext).
not_c(i(A), B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_cs(A, B, A, i(B), r, H, (D, [not_c(i(A), B)|E]), (F, G), '_*'),
	not_ps(i(B), i(A), A, i(B), r, H, (D, [not_c(i(A), B)|E]), (F, [not_cs(A, B, A, i(B))|G]), '_*'),
	not_pc(i(B), i(A), A, B, r, H, (D, [not_c(i(A), B)|E]), (F, [not_ps(i(B), i(A), A, i(B)), not_cs(A, B, A, i(B))|G]), '_*'),
	p_count(ext).
c(A, B, r, C, (D, E), F, '_*') :-
	!,
	p_never_identical(c(A, B), D),
	c(A, B, n, C, (D, E), F, '_*').
c(A, B, n, C, (D, E), F, '_*') :-
	p_identical(not_c(A, B), E),
	!,
	incval(inf),
	p_count(red_cut).
c(A, B, n, C, D, (E, F), '_*') :-
	p_identical(c(A, B), E),
	!,
	incval(inf),
	p_count(factor_cut).
c(A, B, n, C, (D, E), F, '_*') :-
	p_unifiable(not_c(A, B), E),
	incval(inf),
	p_count(red).
c(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	cs(A, B, H, I, r, G, ([c(A, B)|D], E), F, '_*'),
	p_count(ext).
c(A, B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	pc(H, I, A, B, r, G, ([c(A, B)|D], E), F, '_*'),
	p_count(ext).
c(i(A), B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	cs(A, B, A, i(B), r, G, ([c(i(A), B)|D], E), F, '_*'),
	p_count(ext).
c(i(A), B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	pc(i(B), i(A), A, B, r, G, ([c(i(A), B)|D], E), F, '_*'),
	p_count(ext).
c(i(A), B, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	ps(i(B), i(A), A, i(B), r, G, ([c(i(A), B)|D], E), F, '_*'),
	p_count(ext).
c(0, A, n, B, (C, D), (E, F), '_*') :-
	(
	    B >= 1
	->
	    plus(G, 1, B)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	p(0, i(A), r, G, ([c(0, A)|C], D), (E, F), '_*'),
	p(i(A), 0, r, G, ([c(0, A)|C], D), ([p(0, i(A))|E], F), '_*'),
	p_count(ext).
c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, ([c(A, B)|D], E), (F, G), '_*'),
	not_s(A, i(B), r, H, ([c(A, B)|D], E), (F, [not_p(i(B), i(A))|G]), '_*'),
	s(i(A), B, r, H, ([c(A, B)|D], E), (F, [not_s(A, i(B)), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(A, i(B), r, H, ([c(A, B)|D], E), (F, G), '_*'),
	not_s(i(A), B, r, H, ([c(A, B)|D], E), (F, [not_s(A, i(B))|G]), '_*'),
	p(i(B), i(A), r, H, ([c(A, B)|D], E), (F, [not_s(i(A), B), not_s(A, i(B))|G]), '_*'),
	p_count(ext).
c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(i(B), i(A), r, H, ([c(A, B)|D], E), (F, G), '_*'),
	not_s(i(A), B, r, H, ([c(A, B)|D], E), (F, [not_p(i(B), i(A))|G]), '_*'),
	s(A, i(B), r, H, ([c(A, B)|D], E), (F, [not_s(i(A), B), not_p(i(B), i(A))|G]), '_*'),
	p_count(ext).
c(A, B, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	s(A, i(B), r, H, ([c(A, B)|D], E), (F, G), '_*'),
	p(i(B), i(A), r, H, ([c(A, B)|D], E), ([s(A, i(B))|F], G), '_*'),
	s(i(A), B, r, H, ([c(A, B)|D], E), ([p(i(B), i(A)), s(A, i(B))|F], G), '_*'),
	p_count(ext).
not_cs(A, B, C, D, r, E, (F, G), H, '_*') :-
	!,
	p_never_identical(not_cs(A, B, C, D), G),
	not_cs(A, B, C, D, n, E, (F, G), H, '_*').
not_cs(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_identical(cs(A, B, C, D), F),
	!,
	incval(inf),
	p_count(red_cut).
not_cs(A, B, C, D, n, E, F, (G, H), '_*') :-
	p_identical(not_cs(A, B, C, D), H),
	!,
	incval(inf),
	p_count(factor_cut).
not_cs(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_unifiable(cs(A, B, C, D), F),
	incval(inf),
	p_count(red).
not_cs(A, B, C, D, n, E, (F, G), H, '_*') :-
	(
	    E >= 1
	->
	    plus(I, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(C, D, r, I, (F, [not_cs(A, B, C, D)|G]), H, '_*'),
	p_count(ext).
not_cs(A, B, C, D, n, E, (F, G), H, '_*') :-
	(
	    E >= 1
	->
	    plus(I, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(A, B, r, I, (F, [not_cs(A, B, C, D)|G]), H, '_*'),
	p_count(ext).
not_cs(A, B, A, i(B), n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(i(A), B, r, G, (D, [not_cs(A, B, A, i(B))|E]), F, '_*'),
	p_count(ext).
cs(A, B, C, D, r, E, (F, G), H, '_*') :-
	!,
	p_never_identical(cs(A, B, C, D), F),
	cs(A, B, C, D, n, E, (F, G), H, '_*').
cs(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_identical(not_cs(A, B, C, D), G),
	!,
	incval(inf),
	p_count(red_cut).
cs(A, B, C, D, n, E, F, (G, H), '_*') :-
	p_identical(cs(A, B, C, D), G),
	!,
	incval(inf),
	p_count(factor_cut).
cs(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_unifiable(not_cs(A, B, C, D), G),
	incval(inf),
	p_count(red).
cs(A, B, C, D, n, E, (F, G), (H, I), '_*') :-
	(
	    E >= 1
	->
	    plus(J, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	s(C, D, r, J, ([cs(A, B, C, D)|F], G), (H, I), '_*'),
	c(A, B, r, J, ([cs(A, B, C, D)|F], G), ([s(C, D)|H], I), '_*'),
	p_count(ext).
cs(A, B, A, i(B), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_ps(i(B), i(A), A, i(B), r, H, ([cs(A, B, A, i(B))|D], E), (F, G), '_*'),
	not_pc(i(B), i(A), A, B, r, H, ([cs(A, B, A, i(B))|D], E), (F, [not_ps(i(B), i(A), A, i(B))|G]), '_*'),
	c(i(A), B, r, H, ([cs(A, B, A, i(B))|D], E), (F, [not_pc(i(B), i(A), A, B), not_ps(i(B), i(A), A, i(B))|G]), '_*'),
	p_count(ext).
not_ps(A, B, C, D, r, E, (F, G), H, '_*') :-
	!,
	p_never_identical(not_ps(A, B, C, D), G),
	not_ps(A, B, C, D, n, E, (F, G), H, '_*').
not_ps(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_identical(ps(A, B, C, D), F),
	!,
	incval(inf),
	p_count(red_cut).
not_ps(A, B, C, D, n, E, F, (G, H), '_*') :-
	p_identical(not_ps(A, B, C, D), H),
	!,
	incval(inf),
	p_count(factor_cut).
not_ps(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_unifiable(ps(A, B, C, D), F),
	incval(inf),
	p_count(red).
not_ps(A, B, C, D, n, E, (F, G), H, '_*') :-
	(
	    E >= 1
	->
	    plus(I, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_s(C, D, r, I, (F, [not_ps(A, B, C, D)|G]), H, '_*'),
	p_count(ext).
not_ps(A, B, C, D, n, E, (F, G), H, '_*') :-
	(
	    E >= 1
	->
	    plus(I, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(A, B, r, I, (F, [not_ps(A, B, C, D)|G]), H, '_*'),
	p_count(ext).
not_ps(i(A), i(B), B, i(A), n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(i(B), A, r, G, (D, [not_ps(i(A), i(B), B, i(A))|E]), F, '_*'),
	p_count(ext).
ps(A, B, C, D, r, E, (F, G), H, '_*') :-
	!,
	p_never_identical(ps(A, B, C, D), F),
	ps(A, B, C, D, n, E, (F, G), H, '_*').
ps(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_identical(not_ps(A, B, C, D), G),
	!,
	incval(inf),
	p_count(red_cut).
ps(A, B, C, D, n, E, F, (G, H), '_*') :-
	p_identical(ps(A, B, C, D), G),
	!,
	incval(inf),
	p_count(factor_cut).
ps(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_unifiable(not_ps(A, B, C, D), G),
	incval(inf),
	p_count(red).
ps(A, B, C, D, n, E, (F, G), (H, I), '_*') :-
	(
	    E >= 1
	->
	    plus(J, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	s(C, D, r, J, ([ps(A, B, C, D)|F], G), (H, I), '_*'),
	p(A, B, r, J, ([ps(A, B, C, D)|F], G), ([s(C, D)|H], I), '_*'),
	p_count(ext).
ps(i(A), i(B), B, i(A), n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_cs(B, A, B, i(A), r, H, ([ps(i(A), i(B), B, i(A))|D], E), (F, G), '_*'),
	not_pc(i(A), i(B), B, A, r, H, ([ps(i(A), i(B), B, i(A))|D], E), (F, [not_cs(B, A, B, i(A))|G]), '_*'),
	c(i(B), A, r, H, ([ps(i(A), i(B), B, i(A))|D], E), (F, [not_pc(i(A), i(B), B, A), not_cs(B, A, B, i(A))|G]), '_*'),
	p_count(ext).
not_pc(A, B, C, D, r, E, (F, G), H, '_*') :-
	!,
	p_never_identical(not_pc(A, B, C, D), G),
	not_pc(A, B, C, D, n, E, (F, G), H, '_*').
not_pc(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_identical(pc(A, B, C, D), F),
	!,
	incval(inf),
	p_count(red_cut).
not_pc(A, B, C, D, n, E, F, (G, H), '_*') :-
	p_identical(not_pc(A, B, C, D), H),
	!,
	incval(inf),
	p_count(factor_cut).
not_pc(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_unifiable(pc(A, B, C, D), F),
	incval(inf),
	p_count(red).
not_pc(A, B, C, D, n, E, (F, G), H, '_*') :-
	(
	    E >= 1
	->
	    plus(I, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(C, D, r, I, (F, [not_pc(A, B, C, D)|G]), H, '_*'),
	p_count(ext).
not_pc(A, B, C, D, n, E, (F, G), H, '_*') :-
	(
	    E >= 1
	->
	    plus(I, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_p(A, B, r, I, (F, [not_pc(A, B, C, D)|G]), H, '_*'),
	p_count(ext).
not_pc(i(A), i(B), B, A, n, C, (D, E), F, '_*') :-
	(
	    C >= 1
	->
	    plus(G, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_c(i(B), A, r, G, (D, [not_pc(i(A), i(B), B, A)|E]), F, '_*'),
	p_count(ext).
pc(A, B, C, D, r, E, (F, G), H, '_*') :-
	!,
	p_never_identical(pc(A, B, C, D), F),
	pc(A, B, C, D, n, E, (F, G), H, '_*').
pc(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_identical(not_pc(A, B, C, D), G),
	!,
	incval(inf),
	p_count(red_cut).
pc(A, B, C, D, n, E, F, (G, H), '_*') :-
	p_identical(pc(A, B, C, D), G),
	!,
	incval(inf),
	p_count(factor_cut).
pc(A, B, C, D, n, E, (F, G), H, '_*') :-
	p_unifiable(not_pc(A, B, C, D), G),
	incval(inf),
	p_count(red).
pc(A, B, C, D, n, E, (F, G), (H, I), '_*') :-
	(
	    E >= 1
	->
	    plus(J, 1, E)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	c(C, D, r, J, ([pc(A, B, C, D)|F], G), (H, I), '_*'),
	p(A, B, r, J, ([pc(A, B, C, D)|F], G), ([c(C, D)|H], I), '_*'),
	p_count(ext).
pc(i(A), i(B), B, A, n, C, (D, E), (F, G), '_*') :-
	(
	    C >= 1
	->
	    plus(H, 1, C)
	;
	    setval(more_depth, 1),
	    !,
	    fail
	),
	incval(inf),
	not_cs(B, A, B, i(A), r, H, ([pc(i(A), i(B), B, A)|D], E), (F, G), '_*'),
	not_ps(i(A), i(B), B, i(A), r, H, ([pc(i(A), i(B), B, A)|D], E), (F, [not_cs(B, A, B, i(A))|G]), '_*'),
	c(i(B), A, r, H, ([pc(i(A), i(B), B, A)|D], E), (F, [not_ps(i(A), i(B), B, i(A)), not_cs(B, A, B, i(A))|G]), '_*'),
	p_count(ext).

:- set_flag( variable_names, check_singletons).
