#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void header_grd_rule(FILE *mfile,char *name, int i, int j)
{
  fprintf(mfile,"%% %s_%d_%d\n",name,i,j);
}

void footer_grd_rule(FILE *mfile)
{
  fprintf(mfile,".\n\n");
}

void unary_0grd_rule(FILE *mfile,
		     short signA, char *A)
{
  header_grd_rule(mfile,A,0,0);
  if (signA==LP_NEG)
    fprintf(mfile,"%s %s %s",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    A);    
  else
    fprintf(mfile,"%s %s %s%s",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    sym_table[LP_NEG],
	    A);    

  footer_grd_rule(mfile);
}

void unary_1grd_rule(FILE *mfile,
		     short signA, char *A, int i_a)
{
  header_grd_rule(mfile,A,i_a,0);
  if (signA==LP_NEG)
    fprintf(mfile,"%s %s %s(%d)",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    A,i_a);    
  else
    fprintf(mfile,"%s %s %s%s(%d)",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    sym_table[LP_NEG],
	    A,i_a);    
  footer_grd_rule(mfile);
}

void unary_2grd_rule(FILE *mfile,
		     short signA, char *A, int i_a, int j_a)
{
  header_grd_rule(mfile,A,i_a,0);
  if (signA==LP_NEG)
    fprintf(mfile,"%s %s %s(%d,%d)",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    A,i_a,j_a);    
  else
    fprintf(mfile,"%s(%d)",A,i_a);
  footer_grd_rule(mfile);
}

void unary_0x0grd_rule(FILE *mfile,
	     char *Def,
	     short signA, char *A)
{
  header_grd_rule(mfile,Def,0,0);
  fprintf(mfile,"%s %s %s%s",
	 Def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A);
  footer_grd_rule(mfile);
}

void unary_0x1grd_rule(FILE *mfile,
	     char *Def,
	     short signA, char *A, int i_a)
{
  header_grd_rule(mfile,Def,0,0);
  fprintf(mfile,"%s %s %s%s(%d)",
	 Def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a);
  footer_grd_rule(mfile);
}

void unary_1x1grd_rule(FILE *mfile,
	     char *Def, int i_def,
	     short signA, char *A, int i_a)
{
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s%s(%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a);
  footer_grd_rule(mfile);
}

void unary_1x2grd_rule(FILE *mfile,
	     char *Def, int i_def,
	     short signA, char *A, int i_a, int j_a)
{
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s%s(%d,%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,j_a);
  footer_grd_rule(mfile);
}

void binary_2x1grd_rule(FILE *mfile,
		   char *Def, int i_def, int j_def,
		   short signA, char *A, int i_a,
		   short signB, char *B, int i_b)
{  
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d) %s %s%s(%d)",
	 Def,i_def,j_def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a,
	   sym_table[LP_AND],
	 sym_table[signB],
	 B,i_b);
  footer_grd_rule(mfile);
}

void binary_0x0grd_rule(FILE *mfile,
		   char *Def,
		   short signA, char *A,
		   short signB, char *B)
{  
  header_grd_rule(mfile,Def,0,0);
  fprintf(mfile,"%s %s %s%s %s %s%s",
	 Def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,
	   sym_table[LP_AND],
	 sym_table[signB],
	 B);
  footer_grd_rule(mfile);
}

void binary_2x2grd_rule(FILE *mfile,
	      char *Def, int i_def, int j_def,
	      short signA, char *A, int i_a, int j_a,
	      short signB, char *B, int i_b, int j_b)
{  
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d)",
	 Def,i_def,j_def,
	  sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a,j_a,
	  sym_table[LP_AND],
	 sym_table[signB],
	 B,i_b,j_b);
  footer_grd_rule(mfile);
}

void binary_1x1grd_rule(FILE *mfile,
	      char *Def, int i_def,
	      short signA, char *A, int i_a,
	      short signB, char *B, int i_b)
{  
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s%s(%d) %s %s%s(%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b);
  footer_grd_rule(mfile);
}


void binary_4x2grd_rule(FILE *mfile,
	      char *Def, int i_def, int j_def, int k_def, int h_def,
	      short signA, char *A, int i_a, int j_a,
	      short signB, char *B, int i_b, int j_b)
{  
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d,%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d)",
	 Def,i_def,j_def,k_def,h_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,j_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,j_b);
  footer_grd_rule(mfile);
}

void ternary_1x1grd_rule(FILE *mfile,
		    char *Def, int i_def,
		    short signA, char *A, int i_a,
		    short signB, char *B, int i_b,
		    short signC, char *C, int i_c)
{
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d) %s %s%s(%d) %s %s%s(%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,
	   sym_table[LP_AND],
	   sym_table[signC],
	 C,i_c);
  footer_grd_rule(mfile);
}

void ternary_2x2grd_rule(FILE *mfile,
		    char *Def, int i_def, int j_def,
		    short signA, char *A, int i_a, int j_a,
		    short signB, char *B, int i_b, int j_b,
		    short signC, char *C, int i_c, int j_c)
{
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d)",
	 Def,i_def,j_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,j_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,j_b,
	   sym_table[LP_AND],
	   sym_table[signC],
	 C,i_c,j_c);
  footer_grd_rule(mfile);
}


void ternary_2x4grd_rule(FILE *mfile,
	       char *Def, int i_def, int j_def,
	       short signA, char *A, int i_a, int j_a, int h_a, int k_a,
	       short signB, char *B, int i_b, int j_b, int h_b, int k_b,
	       short signC, char *C, int i_c, int j_c, int h_c, int k_c)
{
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d,%d,%d,%d) %s %s%s(%d,%d,%d,%d) %s %s%s(%d,%d,%d,%d)",
	 Def,i_def,j_def,
	   sym_table[LP_RULE],
	   sym_table[signC],
	 A,i_a,j_a,h_a,k_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,j_b,h_b,k_b,
	   sym_table[LP_AND],
	   sym_table[signC],
	 C,i_c,j_c,h_c,k_c);
  footer_grd_rule(mfile);
}



void balanced_product_grd_rules(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Balanced Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<n;j++)
      binary_2x1grd_rule(mfile,"p",i,j,LP_POS,"x",i,LP_POS,"y",j);
  
  /************************************/
  WARN("Balanced Sum Generation")
    
  for(j=0;j<n-1;j++) {
    binary_2x2grd_rule(mfile,"s",0,j,LP_POS,"p",0,j+1,LP_NEG,"p",j+1,0);
    binary_2x2grd_rule(mfile,"s",0,j,LP_NEG,"p",0,j+1,LP_POS,"p",j+1,0);
  }

  for(i=1;i<n-1;i++) {
    for(j=0;j<n-2;j++) {
      ternary_2x2grd_rule(mfile,"s",i,j,LP_POS,"c",i-1,j,LP_NEG,"s",i-1,j+1,LP_NEG,"p",j+1,i);
      ternary_2x2grd_rule(mfile,"s",i,j,LP_NEG,"c",i-1,j,LP_POS,"s",i-1,j+1,LP_NEG,"p",j+1,i);
      ternary_2x2grd_rule(mfile,"s",i,j,LP_NEG,"c",i-1,j,LP_NEG,"s",i-1,j+1,LP_POS,"p",j+1,i);
    }
    ternary_2x2grd_rule(mfile,"s",i,n-2,LP_POS,"c",i-1,n-2,LP_NEG,"p",i,n-1,LP_NEG,"p",n-1,i);
    ternary_2x2grd_rule(mfile,"s",i,n-2,LP_NEG,"c",i-1,n-2,LP_POS,"p",i,n-1,LP_NEG,"p",n-1,i);
    ternary_2x2grd_rule(mfile,"s",i,n-2,LP_NEG,"c",i-1,n-2,LP_NEG,"p",i,n-1,LP_POS,"p",n-1,i);

  }

  binary_2x2grd_rule(mfile,"s",n-1,0,LP_POS,"c",n-2,0,LP_NEG,"s",n-2,1);
  binary_2x2grd_rule(mfile,"s",n-1,0,LP_NEG,"c",n-2,0,LP_POS,"s",n-2,1);

  for(j=1;j<n-2;j++) {
    ternary_2x2grd_rule(mfile,"s",n-1,j,LP_POS,"c",n-2,j,LP_NEG,"s",n-1,j+1,LP_NEG,"c",n-1,j-1);
    ternary_2x2grd_rule(mfile,"s",n-1,j,LP_NEG,"c",n-2,j,LP_POS,"s",n-1,j+1,LP_NEG,"c",n-1,j-1);
    ternary_2x2grd_rule(mfile,"s",n-1,j,LP_NEG,"c",n-2,j,LP_NEG,"s",n-1,j+1,LP_POS,"c",n-1,j-1);
  }
  ternary_2x2grd_rule(mfile,"s",n-1,n-2,LP_POS,"c",n-2,n-2,LP_NEG,"p",n-1,n-1,LP_NEG,"c",n-1,n-3);
  ternary_2x2grd_rule(mfile,"s",n-1,n-2,LP_NEG,"c",n-2,n-2,LP_POS,"p",n-1,n-1,LP_NEG,"c",n-1,n-3);
  ternary_2x2grd_rule(mfile,"s",n-1,n-2,LP_NEG,"c",n-2,n-2,LP_NEG,"p",n-1,n-1,LP_POS,"c",n-1,n-3);
  

  /************************************/
  WARN("Balanced Carry Generation")


  for(j=0;j<n-1;j++)
    binary_2x2grd_rule(mfile,"c",0,j,LP_POS,"p",0,j+1,LP_POS,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    
    for(j=0;j<n-2;j++) {
      binary_2x2grd_rule(mfile,"c",i,j,LP_POS,"c",i-1,j,LP_POS,"p",j+1,i);
      binary_2x2grd_rule(mfile,"c",i,j,LP_POS,"c",i-1,j,LP_POS,"s",i-1,j+1);
      binary_2x2grd_rule(mfile,"c",i,j,LP_POS,"s",i-1,j+1,LP_POS,"p",j+1,i);
    }    
    binary_2x2grd_rule(mfile,"c",i,n-2,LP_POS,"c",i-1,n-2,LP_POS,"p",i,n-1);
    binary_2x2grd_rule(mfile,"c",i,n-2,LP_POS,"c",i-1,n-2,LP_POS,"p",n-1,i);
    binary_2x2grd_rule(mfile,"c",i,n-2,LP_POS,"p",i,n-1,LP_POS,"p",n-1,i);

  }

  binary_2x2grd_rule(mfile,"c",n-1,0,LP_POS,"c",n-2,0,LP_POS,"s",n-2,1);

  for(j=1;j<n-2;j++) {
    binary_2x2grd_rule(mfile,"c",n-1,j,LP_POS,"c",n-2,j,LP_POS,"s",n-1,j+1);
    binary_2x2grd_rule(mfile,"c",n-1,j,LP_POS,"c",n-2,j,LP_POS,"c",n-1,j-1);
    binary_2x2grd_rule(mfile,"c",n-1,j,LP_POS,"s",n-1,j+1,LP_POS,"c",n-1,j-1);

  }
  binary_2x2grd_rule(mfile,"c",n-1,n-2,LP_POS,"c",n-2,n-2,LP_POS,"p",n-1,n-1);
  binary_2x2grd_rule(mfile,"c",n-1,n-2,LP_POS,"c",n-2,n-2,LP_POS,"c",n-1,n-3);
  binary_2x2grd_rule(mfile,"c",n-1,n-2,LP_POS,"p",n-1,n-1,LP_POS,"c",n-1,n-3);

  /************************************/
  WARN("Balanced Result Generation")

  unary_1x2grd_rule(mfile,"m",0,LP_POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_rule(mfile,"m",i,LP_POS,"s",i-1,0);

  for(i=1;i<n;i++)
    unary_1x2grd_rule(mfile,"m",i+n-1,LP_POS,"s",n-1,i-1);

  unary_1x2grd_rule(mfile,"m",2*n-1,LP_POS,"c",n-1,n-2);

}


void product_grd_rules(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<n;j++)
      binary_2x1grd_rule(mfile,"p",i,j,LP_POS,"x",i,LP_POS,"y",j);

  /************************************/
  WARN("Sum Generation")

  for(j=0;j<n-2;j++) {
    binary_2x2grd_rule(mfile,"s",0,j,LP_POS,"p",0,j+1,LP_NEG,"p",j+1,0);
    binary_2x2grd_rule(mfile,"s",0,j,LP_NEG,"p",0,j+1,LP_POS,"p",j+1,0);

  }

  for(i=1;i<n-1;i++) {
    for(j=0;j<i;j++) {
      ternary_2x2grd_rule(mfile,"s",i-j,j,LP_POS,"c",i-j-1,j,LP_NEG,"s",i-j-1,j+1,LP_NEG,"p",j+1,i-j);
      ternary_2x2grd_rule(mfile,"s",i-j,j,LP_NEG,"c",i-j-1,j,LP_POS,"s",i-j-1,j+1,LP_NEG,"p",j+1,i-j);
      ternary_2x2grd_rule(mfile,"s",i-j,j,LP_NEG,"c",i-j-1,j,LP_NEG,"s",i-j-1,j+1,LP_POS,"p",j+1,i-j);
    }
  }  

  /************************************/
  WARN("Carry Generation")

  for(j=0;j<n-2;j++)
    binary_2x2grd_rule(mfile,"c",0,j,LP_POS,"p",0,j+1,LP_POS,"p",j+1,0);

  for(i=1;i<n-1;i++)
    for(j=0;j<i;j++) {
      binary_2x2grd_rule(mfile,"c",i-j,j,LP_POS,"c",i-j-1,j,LP_POS,"p",j+1,i-j);
      binary_2x2grd_rule(mfile,"c",i-j,j,LP_POS,"c",i-j-1,j,LP_POS,"s",i-j-1,j+1);
      binary_2x2grd_rule(mfile,"c",i-j,j,LP_POS,"s",i-j-1,j+1,LP_POS,"p",j+1,i-j);

    }

  /************************************/
  WARN("No Overflow Generation")

  for (i=0;i<n;i++)
    for (j=n-i;j<n;j++)
      unary_2grd_rule(mfile,LP_NEG,"p",i,j);

    for(j=0;j<n-2;j++) {
      unary_2grd_rule(mfile,LP_NEG,"c",n-2-j,j);
      unary_2grd_rule(mfile,LP_NEG,"c",n-2-j,j);
      unary_2grd_rule(mfile,LP_NEG,"c",n-2-j,j);
    }

  /************************************/
  WARN("Result Generation")

  unary_1x2grd_rule(mfile,"m",0,LP_POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_rule(mfile,"m",i,LP_POS,"s",i-1,0);

}

void value_grd_rules(FILE *mfile, char *A, int val, int n)
{
  int i;

  for(i=0;i<n+1;i++) {
    unary_1grd_rule(mfile,((val%2==0)?LP_NEG:LP_POS),A,i);
    val=val/2;
  }

  if (val!=0)
    WARN("Value does not fit in specified-bits")
}


void ordering_grd_rules(FILE *mfile,int n)
{
  int i;

  binary_1x1grd_rule(mfile,"ylex",0,LP_POS,"x",0,LP_NEG,"y",0);

  for(i=1;i<n;i++) {
    binary_1x1grd_rule(mfile,"ylex",i,LP_POS,"x",i,LP_NEG,"y",i);
    ternary_1x1grd_rule(mfile,"ylex",i,LP_POS,"ylex",i-1,LP_POS,"x",i,LP_POS,"y",i);
    ternary_1x1grd_rule(mfile,"ylex",i,LP_POS,"ylex",i-1,LP_NEG,"x",i,LP_NEG,"y",i);

  }
  unary_1grd_rule(mfile,LP_NEG,"ylex",n);
}

void primality_grd_rules(FILE *mfile,int n)
{
  int i;

  for(i=1;i<n;i++)
    unary_0x1grd_rule(mfile,"non_triv_x",LP_POS,"x",i);

  for(i=1;i<n;i++)
    unary_0x1grd_rule(mfile,"non_triv_y",LP_POS,"y",i);

  binary_0x0grd_rule(mfile,"prime",LP_NEG,"non_triv_x",LP_POS,"non_triv_y");

  binary_0x0grd_rule(mfile,"prime",LP_POS,"non_triv_x",LP_NEG,"non_triv_y");

  unary_0grd_rule(mfile,LP_NEG,"prime");
 
}
