int Size=12;

int Product=1591;
int XFactor=43;
int YFactor=37;

char *ProblemFile="formulae.prod";
char *SolutionFile="formulae.factors";

short flag_fof=1;
short flag_ground=0;
short flag_balance=0;
short flag_order=0;
short flag_solX=0;
short flag_solY=0;
short flag_prime=0;
short flag_format=2;

#define HUMAN   0
#define CNF     1
#define TPTP    2
#define SMODELS 3

#define SYMBOLS 19

#define POS 0
#define NEG 1
#define FORALL 2 
#define EXISTS 3
#define AND 4
#define OR 5
#define IMP 6
#define RevIMP 7
#define IFF 8
#define XOR 9

#define ZERO 10
#define SUCC 11
#define VarI 12
#define VarJ 13

#define LP_RULE 14
#define LP_AND 15
#define LP_NEG 16
#define LP_POS 17
#define LP_FALSE 18

char *sym_table[SYMBOLS] ={
  "",
  "~",
  "!",
  "?",
  "&",
  "|",
  "=>",
  "<=",
  "<=>",
  "<~>",
  "0",
  "i",
  "I",
  "J",
  ":-",
  ",",
  "not ",
  "",
  "false"
   };

#define WARN(Z)  {fprintf(stderr,Z);fprintf(stderr,"\n");}










#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* char *strdup(const char *s1);
*/
void ScanParameters(int argc, char *argv[])
{
  int i;

  i=0;
  while(++i<argc)
    if (strcmp(argv[i],"-size")==0) {
      i++;
      Size=(int)atol(argv[i]);
    }
    else if (strcmp(argv[i],"-product")==0) {
      i++;
      Product=(int)atol(argv[i]);
    }
    else if (strcmp(argv[i],"-xfactor")==0) {
      i++;
      XFactor=(int)atol(argv[i]);
      flag_solX=1;
    }
    else if (strcmp(argv[i],"-yfactor")==0) {
      i++;
      YFactor=(int)atol(argv[i]);
      flag_solY=1;
    }
    else if (strcmp(argv[i],"-file")==0) {
      i++;
      ProblemFile=(char *)strdup(argv[i]);
    }
    else if (strcmp(argv[i],"-fof")==0) {
      flag_fof=1;
    }
    else if (strcmp(argv[i],"-ground")==0) {
      flag_ground=1;
    }
    else if (strcmp(argv[i],"-balance")==0) {
      flag_balance=1;
    }
    else if (strcmp(argv[i],"-order")==0) {
      flag_order=1;
    }
    else if (strcmp(argv[i],"-prime")==0) {
      flag_prime=1;
    }
    else if (strcmp(argv[i],"-format")==0) {
      i++;
      flag_format=(short)atoi(argv[i]);
      switch(flag_format) {
	case TPTP    : WARN("TPTP format")
		       break;
        case SMODELS : WARN("SMODELS format")
		       flag_ground=1;
	       	       break;
        case HUMAN   :
        case CNF     :  WARN("Format not implemented yet")
	                exit(1);
	                break;
        default      : WARN("Erroneous format")
	                exit(1);
	               break;
      }
    }
    else {
      WARN("Usage: rsa2fml [-ground|-fof]")
      WARN("Optional parameters: (n is an integer)")
      WARN("-size <n> -product <n> -xfactor <n> -yfactor <n>")
      WARN("-file <name> #Put output in the file name.prod")
      WARN("-fof         #First Order encoding")
      WARN("-ground      #Optimized Ground encoding")
      WARN("-balance     #Product is n-bits and factors are n/2-bits")
      WARN("-order       #factor x < factor y")
      WARN("-prime       #Unsatisfiable if product is prime")
      WARN("-format <n>  # Choose the format of the output")
      WARN("               0 - Human readable format (NOT AVAILABLE YET)")
      WARN("               1 - CNF in list format (NOT AVAILABLE YET)")
      WARN("               2 - TPTP library format (default)")
      WARN("               3 - SMODEL format (implies -ground)")
      WARN(" ")
      WARN("-help        #This printout")
      exit(1);
    }
}


FILE *OpenFile(char *file_name)
{
  FILE *fp;

  fp=fopen(file_name,"w");
  if (fp==NULL) {
    printf("ERROR - cannot open file - ERROR\n");
    printf("%s cannot be created (or rewritten)\n",file_name);
    exit(1);
  }
  return fp;
}




#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void header_fof_fml(FILE *mfile,char *name,int i, int j)
{
  fprintf(mfile,"input_formula(%s_%d_%d,hypothesis,(\n  ",name,i,j);
}

void footer_fof_fml(FILE *mfile)
{
  fprintf(mfile,"\n)).\n\n");
}


short Variable(short term)
{
  return (term==VarI || term==VarJ);
}

void term_fof_fml(FILE *mfile, 
	  short fun,
	  int parenthesis,
	  short var)
{
  int i;
  
  for (i=0;i<parenthesis;i++)
    fprintf(mfile,"%s(",sym_table[fun]);

  fprintf(mfile,"%s",sym_table[var]);

  for (i=0;i<parenthesis;i++)
    fprintf(mfile,")");
}     

void unary_1fof_fml(FILE *mfile,short defconn,
		char *A,
		short fun_a, int i_a, short var_a)
{
  header_fof_fml(mfile,A,i_a,var_a);
  if (Variable(var_a))
    fprintf(mfile,"%s [%s] :",sym_table[FORALL],sym_table[var_a]); 
  fprintf(mfile,"( %s%s(",
	 ((defconn==NEG)?sym_table[NEG]:""),
	 A);
  term_fof_fml(mfile,fun_a,i_a,var_a);
  fprintf(mfile,") )");
  footer_fof_fml(mfile);
}

void product_fof_fml(FILE *mfile,int n)
{
  /************************************/
  WARN("First Order Product Generation")

  header_fof_fml(mfile,"prod",0,0);
  fprintf(mfile,"![I,J] :( p(I,J) <=> (x(I) & y(J)) )");
  footer_fof_fml(mfile);

  /************************************/
  WARN("First Order Sum Generation")

  header_fof_fml(mfile,"sum",0,0);
  fprintf(mfile,"![J] :( s(%s,J) <=> (p(%s,%s(J)) <~> p(%s(J),%s)) )",
	  sym_table[ZERO],sym_table[ZERO],
	  sym_table[SUCC],sym_table[SUCC],
	  sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"sum",1,0);
  fprintf(mfile,"![I,J] :( s(%s(I),J) <=> (c(I,J) <~> s(I,%s(J)) <~> p(%s(J),%s(I))) )",
	  sym_table[SUCC],sym_table[SUCC],
	  sym_table[SUCC],sym_table[SUCC]);
  footer_fof_fml(mfile);


  /************************************/
  WARN("First Order Carry Generation")

  header_fof_fml(mfile,"pc",0,0);
  fprintf(mfile,"![I,J,H,K] :( pc(I,J,H,K) <=> (p(I,J) & c(H,K)) )");
  footer_fof_fml(mfile);
  header_fof_fml(mfile,"ps",0,0);
  fprintf(mfile,"![I,J,H,K] :( ps(I,J,H,K) <=> (p(I,J) & s(H,K)) )");
  footer_fof_fml(mfile);
  header_fof_fml(mfile,"cs",0,0);
  fprintf(mfile,"![I,J,H,K] :( cs(I,J,H,K) <=> (c(I,J) & s(H,K)) )");
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"carry",0,0);
  fprintf(mfile,"![J] :( c(%s,J) <=> (p(%s,%s(J)) & p(%s(J),%s)))",
	  sym_table[ZERO],sym_table[ZERO],
	  sym_table[SUCC],sym_table[SUCC],
	  sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"carry",1,0);
  fprintf(mfile,"![I,J] :( c(%s(I),J) <=> (cs(I,J,I,%s(J)) | ps(%s(J),%s(I),I,%s(J)) | pc(%s(J),%s(I),I,J)) )",
	  sym_table[SUCC],
	  sym_table[SUCC],
	  sym_table[SUCC],sym_table[SUCC],sym_table[SUCC],
	  sym_table[SUCC],sym_table[SUCC]);
  footer_fof_fml(mfile);

  /************************************/
  WARN("First Order Output Generation")

  header_fof_fml(mfile,"mul",0,0);
  fprintf(mfile," m(%s) <=> p(%s,%s)",
	  sym_table[ZERO],sym_table[ZERO],
          sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"mul",1,0);
  fprintf(mfile,"![I] :( m(%s(I)) <=> s(I,%s) )",
	  sym_table[SUCC],sym_table[ZERO]);
  footer_fof_fml(mfile);

  /************************************/
  WARN("First order filtering of unwanted models")

   unary_1fof_fml(mfile,NEG,"x",SUCC,n,VarI);
   unary_1fof_fml(mfile,NEG,"y",SUCC,n,VarI);
   unary_1fof_fml(mfile,NEG,"m",SUCC,n,VarI);
}

void value_fof_fml(FILE *mfile, char *A, int val, int n)
{
  int i;

  for (i=0; i<n+1; i++) {
    unary_1fof_fml(mfile,((val%2==0)?NEG:POS),A,SUCC,i,ZERO);
    val=val/2;
  }

  if (val!=0)
    WARN("Value does not fit in specified-bits")
}

void balanced_product_fof_fml(FILE *mfile,int n)
{

  product_fof_fml(mfile,2*n);

  unary_1fof_fml(mfile,NEG,"x",SUCC,n,VarI);
  unary_1fof_fml(mfile,NEG,"y",SUCC,n,VarI);

}



void ordering_fof_fml(FILE *mfile,int n)
{

  header_fof_fml(mfile,"lex",0,0);
  fprintf(mfile,"![I] :( y(I) => lex(I) )");
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"lex",1,0);
  fprintf(mfile,"![I] :( lex(I) => (x(I) | lex(%s(I)) )",
	  sym_table[SUCC]);
  footer_fof_fml(mfile);

   unary_1fof_fml(mfile,NEG,"lex",SUCC,n,VarI);
}


void primality_fof_fml(FILE *mfile,int n)
{

  header_fof_fml(mfile,"ge2x",0,0);
  fprintf(mfile,"~ge2x(%s)",
	  sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"g2x",1,0);
  fprintf(mfile,"![I] :( ge2x(%s(I)) <=> (x(%s(I)) | ge2x(I)) )",
	  sym_table[SUCC],sym_table[SUCC]);
  footer_fof_fml(mfile);

   unary_1fof_fml(mfile,POS,"ge2x",SUCC,n-1,VarI);

   header_fof_fml(mfile,"ge2y",0,0);
   fprintf(mfile,"~ge2y(%s)",
	   sym_table[ZERO]);
   footer_fof_fml(mfile);
   
   header_fof_fml(mfile,"g2y",1,0);
   fprintf(mfile,"![I] :( ge2y(%s(I)) <=> (y(%s(I)) | ge2y(I)) )",
	   sym_table[SUCC],sym_table[SUCC]);
   footer_fof_fml(mfile);
  
   unary_1fof_fml(mfile,POS,"ge2y",SUCC,n-1,VarI);
}



#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void header_grd_rule(FILE *mfile,char *name, int i, int j)
{
  fprintf(mfile,"%% %s_%d_%d\n",name,i,j);
}

void footer_grd_rule(FILE *mfile)
{
  fprintf(mfile,".\n\n");
}

void unary_0grd_rule(FILE *mfile,
		     short signA, char *A)
{
  header_grd_rule(mfile,A,0,0);
  if (signA==LP_NEG)
    fprintf(mfile,"%s %s %s",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    A);    
  else
    fprintf(mfile,"%s %s %s%s",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    sym_table[LP_NEG],
	    A);    

  footer_grd_rule(mfile);
}

void unary_1grd_rule(FILE *mfile,
		     short signA, char *A, int i_a)
{
  header_grd_rule(mfile,A,i_a,0);
  if (signA==LP_NEG)
    fprintf(mfile,"%s %s %s(%d)",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    A,i_a);    
  else
    fprintf(mfile,"%s %s %s%s(%d)",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    sym_table[LP_NEG],
	    A,i_a);    
  footer_grd_rule(mfile);
}

void unary_2grd_rule(FILE *mfile,
		     short signA, char *A, int i_a, int j_a)
{
  header_grd_rule(mfile,A,i_a,0);
  if (signA==LP_NEG)
    fprintf(mfile,"%s %s %s(%d,%d)",
	    sym_table[LP_FALSE],
	    sym_table[LP_RULE],
	    A,i_a,j_a);    
  else
    fprintf(mfile,"%s(%d)",A,i_a);
  footer_grd_rule(mfile);
}

void unary_0x0grd_rule(FILE *mfile,
	     char *Def,
	     short signA, char *A)
{
  header_grd_rule(mfile,Def,0,0);
  fprintf(mfile,"%s %s %s%s",
	 Def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A);
  footer_grd_rule(mfile);
}

void unary_0x1grd_rule(FILE *mfile,
	     char *Def,
	     short signA, char *A, int i_a)
{
  header_grd_rule(mfile,Def,0,0);
  fprintf(mfile,"%s %s %s%s(%d)",
	 Def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a);
  footer_grd_rule(mfile);
}

void unary_1x1grd_rule(FILE *mfile,
	     char *Def, int i_def,
	     short signA, char *A, int i_a)
{
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s%s(%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a);
  footer_grd_rule(mfile);
}

void unary_1x2grd_rule(FILE *mfile,
	     char *Def, int i_def,
	     short signA, char *A, int i_a, int j_a)
{
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s%s(%d,%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,j_a);
  footer_grd_rule(mfile);
}

void binary_2x1grd_rule(FILE *mfile,
		   char *Def, int i_def, int j_def,
		   short signA, char *A, int i_a,
		   short signB, char *B, int i_b)
{  
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d) %s %s%s(%d)",
	 Def,i_def,j_def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a,
	   sym_table[LP_AND],
	 sym_table[signB],
	 B,i_b);
  footer_grd_rule(mfile);
}

void binary_0x0grd_rule(FILE *mfile,
		   char *Def,
		   short signA, char *A,
		   short signB, char *B)
{  
  header_grd_rule(mfile,Def,0,0);
  fprintf(mfile,"%s %s %s%s %s %s%s",
	 Def,
	   sym_table[LP_RULE],
	 sym_table[signA],
	 A,
	   sym_table[LP_AND],
	 sym_table[signB],
	 B);
  footer_grd_rule(mfile);
}

void binary_2x2grd_rule(FILE *mfile,
	      char *Def, int i_def, int j_def,
	      short signA, char *A, int i_a, int j_a,
	      short signB, char *B, int i_b, int j_b)
{  
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d)",
	 Def,i_def,j_def,
	  sym_table[LP_RULE],
	 sym_table[signA],
	 A,i_a,j_a,
	  sym_table[LP_AND],
	 sym_table[signB],
	 B,i_b,j_b);
  footer_grd_rule(mfile);
}

void binary_1x1grd_rule(FILE *mfile,
	      char *Def, int i_def,
	      short signA, char *A, int i_a,
	      short signB, char *B, int i_b)
{  
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s%s(%d) %s %s%s(%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b);
  footer_grd_rule(mfile);
}


void binary_4x2grd_rule(FILE *mfile,
	      char *Def, int i_def, int j_def, int k_def, int h_def,
	      short signA, char *A, int i_a, int j_a,
	      short signB, char *B, int i_b, int j_b)
{  
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d,%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d)",
	 Def,i_def,j_def,k_def,h_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,j_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,j_b);
  footer_grd_rule(mfile);
}

void ternary_1x1grd_rule(FILE *mfile,
		    char *Def, int i_def,
		    short signA, char *A, int i_a,
		    short signB, char *B, int i_b,
		    short signC, char *C, int i_c)
{
  header_grd_rule(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d) %s %s%s(%d) %s %s%s(%d)",
	 Def,i_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,
	   sym_table[LP_AND],
	   sym_table[signC],
	 C,i_c);
  footer_grd_rule(mfile);
}

void ternary_2x2grd_rule(FILE *mfile,
		    char *Def, int i_def, int j_def,
		    short signA, char *A, int i_a, int j_a,
		    short signB, char *B, int i_b, int j_b,
		    short signC, char *C, int i_c, int j_c)
{
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d) %s %s%s(%d,%d)",
	 Def,i_def,j_def,
	   sym_table[LP_RULE],
	   sym_table[signA],
	 A,i_a,j_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,j_b,
	   sym_table[LP_AND],
	   sym_table[signC],
	 C,i_c,j_c);
  footer_grd_rule(mfile);
}


void ternary_2x4grd_rule(FILE *mfile,
	       char *Def, int i_def, int j_def,
	       short signA, char *A, int i_a, int j_a, int h_a, int k_a,
	       short signB, char *B, int i_b, int j_b, int h_b, int k_b,
	       short signC, char *C, int i_c, int j_c, int h_c, int k_c)
{
  header_grd_rule(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s %s%s(%d,%d,%d,%d) %s %s%s(%d,%d,%d,%d) %s %s%s(%d,%d,%d,%d)",
	 Def,i_def,j_def,
	   sym_table[LP_RULE],
	   sym_table[signC],
	 A,i_a,j_a,h_a,k_a,
	   sym_table[LP_AND],
	   sym_table[signB],
	 B,i_b,j_b,h_b,k_b,
	   sym_table[LP_AND],
	   sym_table[signC],
	 C,i_c,j_c,h_c,k_c);
  footer_grd_rule(mfile);
}



void balanced_product_grd_rules(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Balanced Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<n;j++)
      binary_2x1grd_rule(mfile,"p",i,j,LP_POS,"x",i,LP_POS,"y",j);
  
  /************************************/
  WARN("Balanced Sum Generation")
    
  for(j=0;j<n-1;j++) {
    binary_2x2grd_rule(mfile,"s",0,j,LP_POS,"p",0,j+1,LP_NEG,"p",j+1,0);
    binary_2x2grd_rule(mfile,"s",0,j,LP_NEG,"p",0,j+1,LP_POS,"p",j+1,0);
  }

  for(i=1;i<n-1;i++) {
    for(j=0;j<n-2;j++) {
      ternary_2x2grd_rule(mfile,"s",i,j,LP_POS,"c",i-1,j,LP_NEG,"s",i-1,j+1,LP_NEG,"p",j+1,i);
      ternary_2x2grd_rule(mfile,"s",i,j,LP_NEG,"c",i-1,j,LP_POS,"s",i-1,j+1,LP_NEG,"p",j+1,i);
      ternary_2x2grd_rule(mfile,"s",i,j,LP_NEG,"c",i-1,j,LP_NEG,"s",i-1,j+1,LP_POS,"p",j+1,i);
    }
    ternary_2x2grd_rule(mfile,"s",i,n-2,LP_POS,"c",i-1,n-2,LP_NEG,"p",i,n-1,LP_NEG,"p",n-1,i);
    ternary_2x2grd_rule(mfile,"s",i,n-2,LP_NEG,"c",i-1,n-2,LP_POS,"p",i,n-1,LP_NEG,"p",n-1,i);
    ternary_2x2grd_rule(mfile,"s",i,n-2,LP_NEG,"c",i-1,n-2,LP_NEG,"p",i,n-1,LP_POS,"p",n-1,i);

  }

  binary_2x2grd_rule(mfile,"s",n-1,0,LP_POS,"c",n-2,0,LP_NEG,"s",n-2,1);
  binary_2x2grd_rule(mfile,"s",n-1,0,LP_NEG,"c",n-2,0,LP_POS,"s",n-2,1);

  for(j=1;j<n-2;j++) {
    ternary_2x2grd_rule(mfile,"s",n-1,j,LP_POS,"c",n-2,j,LP_NEG,"s",n-1,j+1,LP_NEG,"c",n-1,j-1);
    ternary_2x2grd_rule(mfile,"s",n-1,j,LP_NEG,"c",n-2,j,LP_POS,"s",n-1,j+1,LP_NEG,"c",n-1,j-1);
    ternary_2x2grd_rule(mfile,"s",n-1,j,LP_NEG,"c",n-2,j,LP_NEG,"s",n-1,j+1,LP_POS,"c",n-1,j-1);
  }
  ternary_2x2grd_rule(mfile,"s",n-1,n-2,LP_POS,"c",n-2,n-2,LP_NEG,"p",n-1,n-1,LP_NEG,"c",n-1,n-3);
  ternary_2x2grd_rule(mfile,"s",n-1,n-2,LP_NEG,"c",n-2,n-2,LP_POS,"p",n-1,n-1,LP_NEG,"c",n-1,n-3);
  ternary_2x2grd_rule(mfile,"s",n-1,n-2,LP_NEG,"c",n-2,n-2,LP_NEG,"p",n-1,n-1,LP_POS,"c",n-1,n-3);
  

  /************************************/
  WARN("Balanced Carry Generation")


  for(j=0;j<n-1;j++)
    binary_2x2grd_rule(mfile,"c",0,j,LP_POS,"p",0,j+1,LP_POS,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    
    for(j=0;j<n-2;j++) {
      binary_2x2grd_rule(mfile,"c",i,j,LP_POS,"c",i-1,j,LP_POS,"p",j+1,i);
      binary_2x2grd_rule(mfile,"c",i,j,LP_POS,"c",i-1,j,LP_POS,"s",i-1,j+1);
      binary_2x2grd_rule(mfile,"c",i,j,LP_POS,"s",i-1,j+1,LP_POS,"p",j+1,i);
    }    
    binary_2x2grd_rule(mfile,"c",i,n-2,LP_POS,"c",i-1,n-2,LP_POS,"p",i,n-1);
    binary_2x2grd_rule(mfile,"c",i,n-2,LP_POS,"c",i-1,n-2,LP_POS,"p",n-1,i);
    binary_2x2grd_rule(mfile,"c",i,n-2,LP_POS,"p",i,n-1,LP_POS,"p",n-1,i);

  }

  binary_2x2grd_rule(mfile,"c",n-1,0,LP_POS,"c",n-2,0,LP_POS,"s",n-2,1);

  for(j=1;j<n-2;j++) {
    binary_2x2grd_rule(mfile,"c",n-1,j,LP_POS,"c",n-2,j,LP_POS,"s",n-1,j+1);
    binary_2x2grd_rule(mfile,"c",n-1,j,LP_POS,"c",n-2,j,LP_POS,"c",n-1,j-1);
    binary_2x2grd_rule(mfile,"c",n-1,j,LP_POS,"s",n-1,j+1,LP_POS,"c",n-1,j-1);

  }
  binary_2x2grd_rule(mfile,"c",n-1,n-2,LP_POS,"c",n-2,n-2,LP_POS,"p",n-1,n-1);
  binary_2x2grd_rule(mfile,"c",n-1,n-2,LP_POS,"c",n-2,n-2,LP_POS,"c",n-1,n-3);
  binary_2x2grd_rule(mfile,"c",n-1,n-2,LP_POS,"p",n-1,n-1,LP_POS,"c",n-1,n-3);

  /************************************/
  WARN("Balanced Result Generation")

  unary_1x2grd_rule(mfile,"m",0,LP_POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_rule(mfile,"m",i,LP_POS,"s",i-1,0);

  for(i=1;i<n;i++)
    unary_1x2grd_rule(mfile,"m",i+n-1,LP_POS,"s",n-1,i-1);

  unary_1x2grd_rule(mfile,"m",2*n-1,LP_POS,"c",n-1,n-2);

}


void product_grd_rules(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<n;j++)
      binary_2x1grd_rule(mfile,"p",i,j,LP_POS,"x",i,LP_POS,"y",j);

  /************************************/
  WARN("Sum Generation")

  for(j=0;j<n-2;j++) {
    binary_2x2grd_rule(mfile,"s",0,j,LP_POS,"p",0,j+1,LP_NEG,"p",j+1,0);
    binary_2x2grd_rule(mfile,"s",0,j,LP_NEG,"p",0,j+1,LP_POS,"p",j+1,0);

  }

  for(i=1;i<n-1;i++) {
    for(j=0;j<i;j++) {
      ternary_2x2grd_rule(mfile,"s",i-j,j,LP_POS,"c",i-j-1,j,LP_NEG,"s",i-j-1,j+1,LP_NEG,"p",j+1,i-j);
      ternary_2x2grd_rule(mfile,"s",i-j,j,LP_NEG,"c",i-j-1,j,LP_POS,"s",i-j-1,j+1,LP_NEG,"p",j+1,i-j);
      ternary_2x2grd_rule(mfile,"s",i-j,j,LP_NEG,"c",i-j-1,j,LP_NEG,"s",i-j-1,j+1,LP_POS,"p",j+1,i-j);
    }
  }  

  /************************************/
  WARN("Carry Generation")

  for(j=0;j<n-2;j++)
    binary_2x2grd_rule(mfile,"c",0,j,LP_POS,"p",0,j+1,LP_POS,"p",j+1,0);

  for(i=1;i<n-1;i++)
    for(j=0;j<i;j++) {
      binary_2x2grd_rule(mfile,"c",i-j,j,LP_POS,"c",i-j-1,j,LP_POS,"p",j+1,i-j);
      binary_2x2grd_rule(mfile,"c",i-j,j,LP_POS,"c",i-j-1,j,LP_POS,"s",i-j-1,j+1);
      binary_2x2grd_rule(mfile,"c",i-j,j,LP_POS,"s",i-j-1,j+1,LP_POS,"p",j+1,i-j);

    }

  /************************************/
  WARN("No Overflow Generation")

  for (i=0;i<n;i++)
    for (j=n-i;j<n;j++)
      unary_2grd_rule(mfile,LP_NEG,"p",i,j);

    for(j=0;j<n-2;j++) {
      unary_2grd_rule(mfile,LP_NEG,"c",n-2-j,j);
      unary_2grd_rule(mfile,LP_NEG,"c",n-2-j,j);
      unary_2grd_rule(mfile,LP_NEG,"c",n-2-j,j);
    }

  /************************************/
  WARN("Result Generation")

  unary_1x2grd_rule(mfile,"m",0,LP_POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_rule(mfile,"m",i,LP_POS,"s",i-1,0);

}

void value_grd_rules(FILE *mfile, char *A, int val, int n)
{
  int i;

  for(i=0;i<n+1;i++) {
    unary_1grd_rule(mfile,((val%2==0)?LP_NEG:LP_POS),A,i);
    val=val/2;
  }

  if (val!=0)
    WARN("Value does not fit in specified-bits")
}


void ordering_grd_rules(FILE *mfile,int n)
{
  int i;

  binary_1x1grd_rule(mfile,"ylex",0,LP_POS,"x",0,LP_NEG,"y",0);

  for(i=1;i<n;i++) {
    binary_1x1grd_rule(mfile,"ylex",i,LP_POS,"x",i,LP_NEG,"y",i);
    ternary_1x1grd_rule(mfile,"ylex",i,LP_POS,"ylex",i-1,LP_POS,"x",i,LP_POS,"y",i);
    ternary_1x1grd_rule(mfile,"ylex",i,LP_POS,"ylex",i-1,LP_NEG,"x",i,LP_NEG,"y",i);

  }
  unary_1grd_rule(mfile,LP_NEG,"ylex",n);
}

void primality_grd_rules(FILE *mfile,int n)
{
  int i;

  for(i=1;i<n;i++)
    unary_0x1grd_rule(mfile,"non_triv_x",LP_POS,"x",i);

  for(i=1;i<n;i++)
    unary_0x1grd_rule(mfile,"non_triv_y",LP_POS,"y",i);

  binary_0x0grd_rule(mfile,"prime",LP_NEG,"non_triv_x",LP_POS,"non_triv_y");

  binary_0x0grd_rule(mfile,"prime",LP_POS,"non_triv_x",LP_NEG,"non_triv_y");

  unary_0grd_rule(mfile,LP_NEG,"prime");
 
}
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void header_grd_fml(FILE *mfile,char *name,int i, int j)
{
  fprintf(mfile,"input_formula(%s_%d_%d,hypothesis,(\n  ",name,i,j);
}

void footer_grd_fml(FILE *mfile)
{
  fprintf(mfile,"\n)).\n\n");
}

void unary_1grd_fml(FILE *mfile,short defconn,
	   char *A, int i_a)
{
  header_grd_fml(mfile,A,i_a,0);
  fprintf(mfile,"%s%s(%d)\n",
	 ((defconn==NEG)?sym_table[NEG]:" "),
	 A,i_a);
  footer_grd_fml(mfile);
}

void unary_1x1grd_fml(FILE *mfile,short defconn,
	     char *Def, int i_def,
	     short connective,
	     char *A, int i_a)
{
  header_grd_fml(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s %s(%d)\n",
	 Def,i_def,
	   sym_table[defconn],
	   ((connective==NEG)?sym_table[NEG]:" "),
	 A,i_a);
  footer_grd_fml(mfile);
}

void unary_1x2grd_fml(FILE *mfile,short defconn,
	     char *Def, int i_def,
	     short connective,
	     char *A, int i_a, int j_a)
{
  header_grd_fml(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s (%s %s(%d,%d))\n",
	 Def,i_def,
	   sym_table[defconn],
	   ((connective==NEG)?sym_table[NEG]:" "),
	 A,i_a,j_a);
  footer_grd_fml(mfile);
}

void binary_2x2grd_fml(FILE *mfile,short defconn,
	      char *Def, int i_def, int j_def,
	      short connective,
	      char *A, int i_a, int j_a,
	      char *B, int i_b, int j_b)
{  
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d,%d) %s %s(%d,%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,j_a,
	   sym_table[connective],
	 B,i_b,j_b);
  footer_grd_fml(mfile);
}

void binary_1x1grd_fml(FILE *mfile,short defconn,
	      char *Def, int i_def,
	      short connective,
	      char *A, int i_a,
	      char *B, int i_b)
{  
  header_grd_fml(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s (%s(%d) %s %s(%d))\n",
	 Def,i_def,
	   sym_table[defconn],
	 A,i_a,
	   sym_table[connective],
	 B,i_b);
  footer_grd_fml(mfile);
}

void binary_2x1grd_fml(FILE *mfile,short defconn,
		   char *Def, int i_def, int j_def,
		   short connective,
		   char *A, int i_a,
		   char *B, int i_b)
{  
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d) %s %s(%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,
	   sym_table[connective],
	 B,i_b);
  footer_grd_fml(mfile);
}

void ternary_2x2grd_fml(FILE *mfile,short defconn,
		    char *Def, int i_def, int j_def,
		    short connective,
		    char *A, int i_a, int j_a,
		    char *B, int i_b, int j_b,
		    char *C, int i_c, int j_c)
{
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d,%d) %s %s(%d,%d) %s %s(%d,%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,j_a,
	   sym_table[connective],
	 B,i_b,j_b,
	   sym_table[connective],
	 C,i_c,j_c);
  footer_grd_fml(mfile);
}


void binary_4x2grd_fml(FILE *mfile,short defconn,
	      char *Def, int i_def, int j_def, int k_def, int h_def,
	      short connective,
	      char *A, int i_a, int j_a,
	      char *B, int i_b, int j_b)
{  
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d,%d,%d) %s (%s(%d,%d) %s %s(%d,%d))\n",
	 Def,i_def,j_def,k_def,h_def,
	   sym_table[defconn],
	 A,i_a,j_a,
	   sym_table[connective],
	 B,i_b,j_b);
  footer_grd_fml(mfile);
}

void ternary_2x4grd_fml(FILE *mfile,short defconn,
	       char *Def, int i_def, int j_def,
	       short connective,
	       char *A, int i_a, int j_a, int h_a, int k_a,
	       char *B, int i_b, int j_b, int h_b, int k_b,
	       char *C, int i_c, int j_c, int h_c, int k_c)
{
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d,%d,%d,%d) %s %s(%d,%d,%d,%d) %s %s(%d,%d,%d,%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,j_a,h_a,k_a,
	   sym_table[connective],
	 B,i_b,j_b,h_b,k_b,
	   sym_table[connective],
	 C,i_c,j_c,h_c,k_c);
  footer_grd_fml(mfile);
}


void balanced_product_grd_fml(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Balanced Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<n;j++)
      binary_2x1grd_fml(mfile,IFF,"p",i,j,AND,"x",i,"y",j);

  /************************************/
  WARN("Balanced Sum Generation")

  for(j=0;j<n-1;j++)
    binary_2x2grd_fml(mfile,IFF,"s",0,j,XOR,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    
    for(j=0;j<n-2;j++)
      ternary_2x2grd_fml(mfile,IFF,"s",i,j,XOR,"c",i-1,j,"s",i-1,j+1,"p",j+1,i);
    
    ternary_2x2grd_fml(mfile,IFF,"s",i,n-2,XOR,"c",i-1,n-2,"p",i,n-1,"p",n-1,i);
  }

  binary_2x2grd_fml(mfile,IFF,"s",n-1,0,XOR,"c",n-2,0,"s",n-2,1);

  for(j=1;j<n-2;j++)
    ternary_2x2grd_fml(mfile,IFF,"s",n-1,j,XOR,"c",n-2,j,"s",n-1,j+1,"c",n-1,j-1);
 
  ternary_2x2grd_fml(mfile,IFF,"s",n-1,n-2,XOR,"c",n-2,n-2,"p",n-1,n-1,"c",n-1,n-3);
  

  /************************************/
  WARN("Balanced Carry Generation")


  for(j=0;j<n-1;j++)
    binary_2x2grd_fml(mfile,IFF,"c",0,j,AND,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    
    for(j=0;j<n-2;j++) {
      binary_4x2grd_fml(mfile,IFF,"cp",i-1,j,j+1,i,AND,"c",i-1,j,"p",j+1,i);
      binary_4x2grd_fml(mfile,IFF,"cs",i-1,j,i-1,j+1,AND,"c",i-1,j,"s",i-1,j+1);
      binary_4x2grd_fml(mfile,IFF,"sp",i-1,j+1,j+1,i,AND,"s",i-1,j+1,"p",j+1,i);

      ternary_2x4grd_fml(mfile,IFF,"c",i,j,OR,
		     "cp",i-1,j,j+1,i,
		     "cs",i-1,j,i-1,j+1,
		     "sp",i-1,j+1,j+1,i);
    }    
    binary_4x2grd_fml(mfile,IFF,"cp1",i-1,n-2,i,n-1,AND,"c",i-1,n-2,"p",i,n-1);
    binary_4x2grd_fml(mfile,IFF,"cp2",i-1,n-2,n-1,i,AND,"c",i-1,n-2,"p",n-1,i);
    binary_4x2grd_fml(mfile,IFF,"pp",i,n-1,n-1,i,AND,"p",i,n-1,"p",n-1,i);

    ternary_2x4grd_fml(mfile,IFF,"c",i,n-2,OR,
		   "cp1",i-1,n-2,i,n-1,
		   "cp2",i-1,n-2,n-1,i,
		   "pp",i,n-1,n-1,i);
  }

  binary_2x2grd_fml(mfile,IFF,"c",n-1,0,AND,"c",n-2,0,"s",n-2,1);

  for(j=1;j<n-2;j++) {
    binary_4x2grd_fml(mfile,IFF,"cs",n-2,j,n-1,j+1,AND,"c",n-2,j,"s",n-1,j+1);
    binary_4x2grd_fml(mfile,IFF,"cc",n-2,j,n-1,j-1,AND,"c",n-2,j,"c",n-1,j-1);
    binary_4x2grd_fml(mfile,IFF,"sc",n-1,j+1,n-1,j-1,AND,"s",n-1,j+1,"c",n-1,j-1);

    ternary_2x4grd_fml(mfile,IFF,"c",n-1,j,OR,
		   "cs",n-2,j,n-1,j+1,
		   "cc",n-2,j,n-1,j-1,
		   "sc",n-1,j+1,n-1,j-1);
  }
  binary_4x2grd_fml(mfile,IFF,"cp",n-2,n-2,n-1,n-1,AND,"c",n-2,n-2,"p",n-1,n-1);
  binary_4x2grd_fml(mfile,IFF,"cc",n-2,n-2,n-1,n-3,AND,"c",n-2,n-2,"c",n-1,n-3);
  binary_4x2grd_fml(mfile,IFF,"pc",n-1,n-1,n-1,n-3,AND,"p",n-1,n-1,"c",n-1,n-3);

  ternary_2x4grd_fml(mfile,IFF,"c",n-1,n-2,OR,
		 "cp",n-2,n-2,n-1,n-1,
		 "cc",n-2,n-2,n-1,n-3,
		 "pc",n-1,n-1,n-1,n-3);
		 

  /************************************/
  WARN("Balanced Result Generation")

  unary_1x2grd_fml(mfile,IFF,"m",0,POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_fml(mfile,IFF,"m",i,POS,"s",i-1,0);

  for(i=1;i<n;i++)
    unary_1x2grd_fml(mfile,IFF,"m",i+n-1,POS,"s",n-1,i-1);

  unary_1x2grd_fml(mfile,IFF,"m",2*n-1,POS,"c",n-1,n-2);

}


void product_grd_fml(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<i+1;j++)
      binary_2x1grd_fml(mfile,IFF,"p",i-j,j,AND,"x",i-j,"y",j);

  /************************************/
  WARN("Sum Generation")

  for(j=0;j<n-1;j++)
    binary_2x2grd_fml(mfile,IFF,"s",0,j,XOR,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    for(j=0;j<i;j++)
      ternary_2x2grd_fml(mfile,IFF,"s",i-j,j,XOR,"c",i-j-1,j,"s",i-j-1,j+1,"p",j+1,i-j);
  }  

  /************************************/
  WARN("Carry Generation")


  for(j=0;j<n-2;j++)
    binary_2x2grd_fml(mfile,IFF,"c",0,j,AND,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-2;i++)
    for(j=0;j<i;j++) {
      binary_4x2grd_fml(mfile,IFF,"cp",i-j-1,j,j+1,i,AND,"c",i-j-1,j,"p",j+1,i-j);
      binary_4x2grd_fml(mfile,IFF,"cs",i-j-1,j,i-j-1,j+1,AND,"c",i-j-1,j,"s",i-j-1,j+1);
      binary_4x2grd_fml(mfile,IFF,"sp",i-j-1,j+1,j+1,i-j,AND,"s",i-j-1,j+1,"p",j+1,i-j);

      ternary_2x4grd_fml(mfile,IFF,"c",i-j,j,OR,
		     "cp",i-j-1,j,j+1,i-j,
		     "cs",i-j-1,j,i-j-1,j+1,
		     "sp",i-j-1,j+1,j+1,i-j);
    }

  /************************************/
  WARN("Result Generation")

  unary_1x2grd_fml(mfile,IFF,"m",0,POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_fml(mfile,IFF,"m",i,POS,"s",i-1,0);

}

void value_grd_fml(FILE *mfile, char *A, int val, int n)
{
  int i;

  for(i=0;i<n+1;i++) {
    unary_1grd_fml(mfile,((val%2==0)?NEG:POS),A,i);
    val=val/2;
  }

  if (val!=0)
    WARN("Value does not fit in specified-bits")
}


void balance_grd_fml(FILE *mfile,int n)
{
  int i;

  for(i=n;i<2*n;i++) {
    unary_1grd_fml(mfile,NEG,"x",i);
    unary_1grd_fml(mfile,NEG,"y",i);
  }
}

void ordering_grd_fml(FILE *mfile,int n)
{
  int i;

  for(i=0;i<n;i++) {
    unary_1x1grd_fml(mfile,IMP,"y",i,POS,"lex",i);
    binary_1x1grd_fml(mfile,IMP,"lex",i,OR,"x",i,"lex",i+1);
  }
  unary_1grd_fml(mfile,NEG,"lex",n);
}

void primality_grd_fml(FILE *mfile,int n)
{
  int i;

  unary_1grd_fml(mfile,NEG,"ge2x",0);

  for(i=1;i<n;i++) {
    binary_1x1grd_fml(mfile,IFF,"ge2x",i,OR,"x",i,"ge2x",i-1);
  }
  unary_1grd_fml(mfile,NEG,"ge2x",n-1);

  unary_1grd_fml(mfile,NEG,"ge2y",0);

  for(i=1;i<n;i++) {
    binary_1x1grd_fml(mfile,IFF,"ge2y",i,OR,"y",i,"ge2y",i-1);
  }
  unary_1grd_fml(mfile,NEG,"ge2y",n-1);
}



#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void balanced_product(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                balanced_product_fof_fml(mfile,n/2);
             else if (flag_ground)
                balanced_product_grd_fml(mfile,n/2);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  balanced_product_grd_rules(mfile,n/2);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void product(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                product_fof_fml(mfile,n);
             else if (flag_ground)
                product_grd_fml(mfile,n);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  product_grd_rules(mfile,n);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void value(FILE *mfile, char *A, int val, int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                value_fof_fml(mfile,A,val,n);
             else if (flag_ground)
                value_grd_fml(mfile,A,val,n);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  value_grd_rules(mfile,A,val,n);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void ordering(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                ordering_fof_fml(mfile,n/2);
             else if (flag_ground)
                ordering_grd_fml(mfile,n/2);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  ordering_grd_rules(mfile,n/2);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void primality(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                primality_fof_fml(mfile,n/2);
             else if (flag_ground)
                primality_grd_fml(mfile,n/2);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  primality_grd_rules(mfile,n/2);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void choices(FILE *mfile,char *A,int n)
{
   int i;
   if (flag_balance) n=n/2;
   for (i=0;i<n;i++)
     fprintf(mfile,"{ %s(%i) }.\n",A,i);
}
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{

  FILE *probfp;
  FILE *solfp;

  ScanParameters(argc,argv);

  probfp=OpenFile(ProblemFile);

  if (flag_solX || flag_solY) {
    SolutionFile=(char *)strdup(ProblemFile);
    strcat(SolutionFile,".factors");
    solfp=OpenFile(SolutionFile);
  }

  if (flag_solX && flag_solY) {
    Product=XFactor*YFactor;
  }

  if (flag_balance && Size%2!=0) {
    WARN("When balanced, size must be even\n... rounding down")
    Size=Size-1;
  }
  
  if (flag_balance) {
    WARN("Balanced Encoding M=X*Y")
    balanced_product(probfp,Size/2);
  }
  else {
    WARN("Standard Encoding M=X*Y")
    product(probfp,Size);
  }

  if (flag_order) {
    WARN("Encoding X < Y")
    ordering(probfp,Size/2);
  }
  if (flag_prime) {
    WARN("Encoding Product M is Not Prime")
    primality(probfp,Size);
  }
    
  WARN("Encoding Value Product M")
  value(probfp,"m",Product,Size);

  if (flag_solX) {
    WARN("Encoding Value Factor X")
    value(solfp,"x",XFactor,Size);
  }
  if (flag_solY) {
    WARN("Encoding Value Factor Y")
    value(solfp,"y",YFactor,Size);
  }
  
  if (flag_format==SMODELS) {
    WARN("Encoding Choices for Y and X for NMR")
    choices(probfp,"x",Size);
    choices(probfp,"y",Size);
  } 

  if (flag_solY || flag_solY) 
    fclose(solfp);
  fclose(probfp);

  return(0);
}





