/**CFile***********************************************************************

  FileName    [simMemory.c]

  PackageName [sim]

  Synopsis    [Memory handling]

  Description [Internal procedures included in this module:
		<ul>
		<li> <b>SimDllStartMemory()</b> begin memory accounting
		<li> <b>SimDllStopMemory()</b> end memory accounting
		<li> <b>SimDllSetMemout()</b> sets the memory-out
		</ul>]
		
  SeeAlso     [sim.h]

  Author      [Armando Tacchella]

  Copyright   [Copyright (c) 2000 by DIST - Universita' di Genova, Italia.  
               All Rights Reserved. This software is for educational
               purposes only.  Permission is given to academic
               institutions to use, copy, and modify this software and
               its documentation provided that this introductory
               message is not removed, that this software and its
               documentation is used for the institutions' internal
               research and educational purposes, and that no monies
               are exchanged. No guarantee is expressed or implied by
               the distribution of this code.  Permission to
               distribute this code is given to ITC-IRST,
               provided that the code is distributed as is.
               Send bug-reports and/or questions to: sim@mrg.dist.unige.it]

  Revision    [v. 1beta]

******************************************************************************/

#include "simInt.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

#ifdef HAVE_SYS_TIME_H
#ifdef HAVE_SYS_RESOURCE_H
#ifdef HAVE_UNISTD_H

/* A lot of stuff, needed by getrusage, get/setrlimit to work properly. */
#define HAVE_MEMORY

#endif
#endif
#endif


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Starts memory accounting.]

  Description [Sets the given counter to the current unshared data size.]

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
void
SimDllStartMemory(
  int             i)		  
{
  
#ifdef HAVE_MEMORY
  struct rusage t;

  getrusage(RUSAGE_SELF, &t);
  SimStat[i] = (int)t.ru_idrss;
#endif

  return;

} /* End of SimDllBeginMemory. */


/**Function********************************************************************

  Synopsis    [Stops memory accounting.]

  Description [Sets the given counter to the current unshared data size
               minus the old counter value.]

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
void
SimDllStopMemory(
  int             i)
{
  
#ifdef HAVE_MEMORY
  struct rusage t;
  long          now;

  getrusage(RUSAGE_SELF, &t);
  now = t.ru_idrss - (long)SimStat[i];
  SimStat[i] = (int)now;
#endif

  return;

} /* End of SimDllStopMemory. */


/**Function********************************************************************

  Synopsis    [Sets the memeout on the process.]

  Description [Sets the specified memeout using the CPU resource limit
               mechanism.]

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
void
SimDllSetMemout(
  int             mmout)
{
  
#ifdef HAVE_MEMORY
  struct rlimit r;          
  
  if (mmout > 0) {
    getrlimit(RLIMIT_DATA, &r);
    r.rlim_cur = mmout;       
    setrlimit(RLIMIT_DATA, &r);
  }
#endif
  
  return;
  
} /* End of SimSetMemout. */







