/**CFile***********************************************************************

  FileName    [simCons.c]

  PackageName [sim]

  Synopsis    [Consistency checking routines.]

  Description [External procedures included in this module:
		<ul>
		<li> <b>SimDllGetModels()</b> checks if the
                     number of open clauses is zero. If so, decrements 
		     the number of solutions to find;   
		<li> <b>SimDllGetModelsHorn()</b> checks if the
                     number of open non-horn clauses is zero. If so, 
		     decrements the number of solutions to find.
		</ul>]
		
  SeeAlso     [simSolve.c]

  Author      [Armando Tacchella, Davide Zambonin]

  Copyright   [Copyright (c) 2000 by DIST - Universita' di Genova, Italia.  
               All Rights Reserved. This software is for educational
               purposes only.  Permission is given to academic
               institutions to use, copy, and modify this software and
               its documentation provided that this introductory
               message is not removed, that this software and its
               documentation is used for the institutions' internal
               research and educational purposes, and that no monies
               are exchanged. No guarantee is expressed or implied by
               the distribution of this code.  Permission to
               distribute this code is given to ITC-IRST,
               provided that the code is distributed as is.
               Send bug-reports and/or questions to: sim@mrg.dist.unige.it]

  Revision    [v. 1beta]


******************************************************************************/

#include "simInt.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Consistency checkingl.]

  Description [Consistency checking.]

  SideEffects [none]

  SeeAlso     [Sim_DllSolve]

******************************************************************************/
int 
SimDllGetModels( 
   int       * stop	   
  )
{
  int redundant;

  if (SimCnt[SIMCUR_CL_NUM] == 0) {
    /* If the formula was declared satisfiable, check the assignment found. */
    if (SimDllCheck(&redundant) == SIM_UNSAT) {
      SimDllThrow(SIM_INTERNAL_ERROR, 
		  "Sim_DllCheck: assignment is not verified!");
    } else if (redundant != 0) { 
      fprintf(stderr, "Warning: there are %d redundant assignments\n", 
	      redundant); 
    } 
    /* If the number of open clauses is 0, check if the number of request 
       solution is reached. If so stop, otherwise go on in the enumeration. */
    if( --SimParam[SIM_SOL_NUM] == 0) {
      *stop = 1;
    } else {
      *stop = 0;
    }
    SimDllStatAdd(SIMSOL_NODE_NUM, SimCnt[SIMCUR_LEVEL]);
    SimDllStatUpdateMax(SIMDEPTH_MAX, SimCnt[SIMCUR_LEVEL]);
    return SIM_SAT;
  } else {
    /* If there are still open clauses at this point, return SIM_UNSAT. */
    *stop = 1;
    return SIM_UNSAT;
  }

} /* End of SimDllGetModels. */


/**Function********************************************************************

  Synopsis    [Consistency checking with horn relaxation.]

  Description [Consistency checking  with horn relaxation.]

  SideEffects [none]

  SeeAlso     [Sim_DllSolve]

******************************************************************************/
int 
SimDllGetModelsHorn(
   int       * stop       
  )
{

  int redundant;

  if (SimCnt[SIMCUR_NHCL_NUM] == 0) {
    /* If the formula was declared satisfiable, check the assignment found. */
    if (SimDllCheck(&redundant) == SIM_UNSAT) {
      SimDllThrow(SIM_INTERNAL_ERROR, 
		  "Sim_DllCheck: assignment is not verified!");
    } else if (redundant != 0) { 
      fprintf(stderr, "Warning: there are %d redundant assignments\n", 
	      redundant); 
    } 
  /* If the number of open clauses is 0, check if the number of request 
     solution is reached. If so stop, otherwise go on in the enumeration. */
    if( --SimParam[SIM_SOL_NUM] == 0) {
      *stop = 1;
    } else {
      *stop = 0;
    }
    SimDllStatAdd(SIMSOL_NODE_NUM, SimCnt[SIMCUR_LEVEL]);
    SimDllStatUpdateMax(SIMDEPTH_MAX, SimCnt[SIMCUR_LEVEL]);
    return SIM_SAT;
  } else {
    /* If there are still open clauses at this point, return SIM_UNSAT. */
    *stop = 1;
    return SIM_UNSAT;
  }


} /* End of SimDllGetModelsHorn */





