/**CFile***********************************************************************

  FileName    [simClause.c]

  PackageName [sim]

  Synopsis    [Primitives for clauses.]

  Description [Internal procedures included in this module:
		<ul>
		<li> <b>SimClauseInit()</b> clause construtor
		<li> <b>SimClauseClear()</b> clause destructor
		</ul>]
		
  SeeAlso     [sim.h]

  Author      [Armando Tacchella]

  Copyright   [Copyright (c) 2000 by DIST - Universita' di Genova, Italia.  
               All Rights Reserved. This software is for educational
               purposes only.  Permission is given to academic
               institutions to use, copy, and modify this software and
               its documentation provided that this introductory
               message is not removed, that this software and its
               documentation is used for the institutions' internal
               research and educational purposes, and that no monies
               are exchanged. No guarantee is expressed or implied by
               the distribution of this code.  Permission to
               distribute this code is given to ITC-IRST,
               provided that the code is distributed as is.
               Send bug-reports and/or questions to: sim@mrg.dist.unige.it]

  Revision    [v. 1beta]


******************************************************************************/


#include "simInt.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Initializes a clause.]

  Description [Initializes a clause.]

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
SimClause_t*
SimClauseInit(
  int   clId,
  short clSize)		  
{
  
  SimClause_t * cl = (SimClause_t*)malloc(sizeof(SimClause_t));
  SimDllMemCheck(cl, "SimClauseInit");

  /* Initialize data fields. */
  cl -> openLitNum = cl -> posLitNum = 0;
  cl -> sub = 0;
  cl -> backClauses = clId;

  /* Initialize 0-terminated list of proposition references. */
  VinitReserve0(cl -> lits, clSize);
  SimDllMemCheck(V(cl -> lits), "SimClauseInit");
  
#ifdef HORN_RELAXATION
  cl -> backNhClauses = -1;
#endif
#ifdef LEARNING
  cl -> backUnitLearned = SIMALLOW_UNIT;
  cl -> learned = -1;
#endif

  return cl;

} /* End of SimClauseInit. */


/**Function********************************************************************

  Synopsis    [Clears a clause.]

  Description [Clears a clause.]

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
void 
SimClauseClear(
  SimClause_t * cl)
{
  
  Vclear(cl -> lits);
  free(cl);

  return;

}
