/* strutt.h: file header che contiene le definizioni delle strutture dati
	     usate per memorizzare le formule                             */

#ifndef STRUTTURE
#define STRUTTURE 

enum elemento{FALSE=0,TRUE,VARIABILE};
struct variabile
{	char nome; /* nome attribuito alla variabile */
	int posizione_bit; /* indice indicante la posizione del bit cui la
	                      variabile fa riferimento                    */  
	int numero_iterazione; /* indice che individua l'iterazione in cui
	                          la variabile  stata introdotta         */
	int numero_blocco; /* indice che individua il blocco di plaintext
	                      cui la variabile si riferisce               */ 
	int negata; /* 0 indica che la variabile non  negata, 1 che lo  */
};
        
struct formula
{	elemento tipo_elemento; /* indica se l'elemento  true, false
                                   oppure una variabile                   */
	variabile* var; /* se l'elemento  una variabile allora il
	                   puntatore punta alla struttura che la individua*/
	formula* succ; /* punta all'elemento successivo                   */
};
/* La struttura successiva  usata per rappresentare le definizioni.
   Ad esempio: A=B+C  A parte_sinistra, B+C parte_destra                  */
struct definizione
{	formula* parte_sinistra;
	formula* parte_destra;
};
/* Lista che contiene tutte le formule che contengono solo AND           */
struct lista_and
{	definizione* formula_and;
	lista_and* next;
};
/* Lista che contiene tutte le formule che contengono solo OR           */
struct lista_or
{	definizione* formula_or;
	lista_or* next;
};
/* Lista che contiene tutte le formule che contengono solo XOR           */
struct lista_xor
{	definizione* formula_xor;
	lista_xor* next;
};
/* Lista che contiene tutte le formule che sono identit                */
struct lista_identita
{	definizione* identita;
	lista_identita* next;
};

#endif
