/* scrivi_fof.c: modulo che costruisce i files contenenti le formule in
	           formato numerico da analizzare tramite algoritmi di
	           ricerca                                           */

#include <stdio.h>
#include <ctype.h>
#include "strutt.h"
#include "stampa_fof.h"

extern lista_and* and;
extern lista_or* or;
extern lista_xor* xor;
extern lista_identita* id;

#define POS 1
#define NEG -1

/* Funzione che scrive nel file ins_file l'elemento temp di una formula.  */

void scrivi_fof_lit(FILE* sis,formula* fml,short segno)
{

  char var;

  if(fml->tipo_elemento==VARIABILE) {

    var = (char)tolower(fml->var->nome);

    if(!fml->var->negata)
      segno *= POS;
    else
      segno *= NEG;

    if (segno!=POS)
      fprintf(sis,"~");

    fprintf(sis,"%c(%ld,%ld",var,
                             fml->var->numero_blocco,
                             fml->var->posizione_bit);
    if (var!='k' && var!='c' && var!='p')
      fprintf(sis,",%ld",fml->var->numero_iterazione);
    fprintf(sis,")");
      
  }
  else {
    if(fml->tipo_elemento==TRUE)
      fprintf(sis,"true");
    else fprintf(sis,"false");
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista id.
   Tale lista contiene le formule di tipo identit: es. A=B.              */                 
void scrivi_fof_fml(FILE* sis,lista_identita* id)
{
  formula *A,*B;

  long number=0;

  while(id!=0) {
    fprintf(sis,"input_formula(def(id,%ld),hypothesis,\n",++number);

    A=id->identita->parte_sinistra;
    B=id->identita->parte_destra;

    if (B->tipo_elemento==VARIABILE) {
      scrivi_fof_lit(sis,A,POS);
      fprintf(sis," <=> ");
      scrivi_fof_lit(sis,B,POS);
    }
    else {
      if (B->tipo_elemento==TRUE)
        scrivi_fof_lit(sis,A,POS);
      else
        scrivi_fof_lit(sis,A,NEG);
    }

    fprintf(sis,"\n ).\n\n");
    fflush(sis);

    id=id->next;
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista xor.
   Tale lista contiene le formule di tipo xor: es. A=xor(B,C).            */                 
void scrivi_fof_fml(FILE* sis,lista_xor* xor)
{
  formula *A,*B,*C;
  long number=0;

  while(xor!=0) {
    fprintf(sis,"input_formula(def(xor,%ld),hypothesis,\n",++number);

    A=xor->formula_xor->parte_sinistra;
    B=xor->formula_xor->parte_destra;
    C=B->succ;

    if (A->tipo_elemento==VARIABILE) {
      scrivi_fof_lit(sis,A,POS);
      fprintf(sis," <=> ");
    }
    else {
      if (A->tipo_elemento==FALSE)
	fprintf(sis," ~");
    }
    fprintf(sis," (");
    scrivi_fof_lit(sis,B,POS);
    fprintf(sis," <~> ");
    scrivi_fof_lit(sis,C,POS);
    fprintf(sis," )");

    fprintf(sis,"\n ).\n\n");
    fflush(sis);

    xor=xor->next;
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista and.
   Tale lista contiene le formule di tipo and: es. A=and(B,C).            */                 
void scrivi_fof_fml(FILE* sis,lista_and* and)
{
  formula *A,*B;

  long number=0;

  while(and!=0) {
    fprintf(sis,"input_formula(def(and,%ld),hypothesis,\n",++number);

    A=and->formula_and->parte_sinistra;
    B=and->formula_and->parte_destra;

    if (A->tipo_elemento==VARIABILE) {
      scrivi_fof_lit(sis,A,POS);
      fprintf(sis," <=>");
    }
    else {
      if (A->tipo_elemento==FALSE)
	fprintf(sis," ~");
    }
    fprintf(sis," (");
    while(B!=0) {
      scrivi_fof_lit(sis,B,POS);
      if (B->succ!=0)
	fprintf(sis," & ");
      else
	fprintf(sis," )");
      B=B->succ;
    }
    
    fprintf(sis,"\n  ).\n\n");
    fflush(sis);

    and=and->next;
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista or.
   Tale lista contiene le formule di tipo or: es. A=or(B,C).            */

void scrivi_fof_fml(FILE* sis,lista_or* or)
{
  formula *A,*B;

  long number=0;

  while(or!=0) {
    fprintf(sis,"input_formula(def(or,%ld),hypothesis,\n",++number);

    A=or->formula_or->parte_sinistra;
    B=or->formula_or->parte_destra;

    if (A->tipo_elemento==VARIABILE) {
      scrivi_fof_lit(sis,A,POS);
      fprintf(sis," <=>");
    }
    else {
      if (A->tipo_elemento==FALSE)
	fprintf(sis," ~");
    }
    fprintf(sis,"( ");
    while(B!=0) {
      scrivi_fof_lit(sis,B,POS);
      if (B->succ!=0)
	fprintf(sis," | ");
      else
	fprintf(sis," )");
      B=B->succ;
    }
    fprintf(sis,"\n  ).\n\n");
    fflush(sis);

    or=or->next;
  }
}


void scrivi_fof(FILE* sis)
{
//  scrivi_fof_fml(sis,id);
  scrivi_fof_fml(sis,and);
  scrivi_fof_fml(sis,or);
  scrivi_fof_fml(sis,xor);
}



