/* scrivi.c: modulo che effettua gli inserimenti delle formule nelle liste */

#include "scrivi.h"
#include <stdio.h>

extern lista_identita* identity;
extern lista_identita* ultimo;
extern lista_xor* xor;
extern lista_xor* ultimo_xor;
extern lista_or* or;
extern lista_or* ultimo_or;
extern lista_and* and;
extern lista_and* ultimo_and;

/* Funzione che inserisce una formula in un'apposita lista.
   La convenzione  la seguente:
   lista=0: inserisci nella lista delle identit
   lista=1: inserisci nella lista delle xor
   lista=2: inserisci nella lista delle and
   lista=3: inserisci nella lista degli or                   */
void scrivi_in_lista(variabile* variabili, int lista)
{   int j;
	lista_identita* definizioni_identita;
	lista_xor* definizioni_xor;
	lista_or* definizioni_or;
	lista_and* definizioni_and;
	definizione* def;
	formula* formu;
	formula* formu1;
	switch(lista)
	{/* inserisci nella lista contenente le identit */
	 case 0:
	   /* verifica se la lista  vuota */
	   if(identity==0)
	   { /* se  vuota crea la lista */
	     identity=new lista_identita;
	     identity->identita=new definizione;
	     def=identity->identita;
	     def->parte_sinistra=new formula;
         formu=def->parte_sinistra;
	     formu->tipo_elemento=VARIABILE;
         formu->var=new variabile;
	     formu->var->nome=variabili[0].nome;
	     formu->var->posizione_bit=variabili[0].posizione_bit;
	     formu->var->numero_iterazione=variabili[0].numero_iterazione;
	     formu->var->numero_blocco=variabili[0].numero_blocco;
	     formu->var->negata=variabili[0].negata;
	     formu->succ=0;
	     j=1;
  	     def->parte_destra=new formula;
	     def->parte_destra->tipo_elemento=VARIABILE;
	     def->parte_destra->var=new variabile;
	     def->parte_destra->var->nome=variabili[j].nome;
	     def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	     def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	     def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	     def->parte_destra->var->negata=variabili[j].negata;
	     def->parte_destra->succ=0;
         identity->next=0;
	     ultimo=identity;
	     return;
	   }
	   /* se non  vuota aggiungi la formula in coda */
	   definizioni_identita=new lista_identita;
       definizioni_identita->identita=new definizione;
	   def=definizioni_identita->identita;
	   def->parte_sinistra=new formula;
       formu=def->parte_sinistra;
	   formu->tipo_elemento=VARIABILE;
       formu->var=new variabile;
	   formu->var->nome=variabili[0].nome;
	   formu->var->posizione_bit=variabili[0].posizione_bit;
	   formu->var->numero_iterazione=variabili[0].numero_iterazione;
	   formu->var->numero_blocco=variabili[0].numero_blocco;
	   formu->var->negata=variabili[0].negata;
	   formu->succ=0;
	   j=1;
	   def->parte_destra=new formula;
	   def->parte_destra->tipo_elemento=VARIABILE;
	   def->parte_destra->var=new variabile;
	   def->parte_destra->var->nome=variabili[j].nome;
	   def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	   def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	   def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	   def->parte_destra->var->negata=variabili[j].negata;
	   def->parte_destra->succ=0;
	   formu1=def->parte_destra;
	   definizioni_identita->next=0;
	   ultimo->next=definizioni_identita;
	   ultimo=definizioni_identita;
	   return;
	 /* inserisci nella lista contenente le formule XOR */
	 case 1:
	   /* verifica se la lista  vuota */
	   if(xor==0)
	   { /* se  vuota crea la lista */
	     xor=new lista_xor;
	     xor->formula_xor=new definizione;
	     def=xor->formula_xor;
	     def->parte_sinistra=new formula;
         formu=def->parte_sinistra;
	     formu->tipo_elemento=VARIABILE;
         formu->var=new variabile;
	     formu->var->nome=variabili[0].nome;
	     formu->var->posizione_bit=variabili[0].posizione_bit;
	     formu->var->numero_iterazione=variabili[0].numero_iterazione;
	     formu->var->numero_blocco=variabili[0].numero_blocco;
	     formu->var->negata=variabili[0].negata;
	     formu->succ=0;
	     j=1;
	     def->parte_destra=0;
	     while(variabili[j].nome!=0)
	     {  /* verifica se la parte destra  vuota */
	        if(def->parte_destra!=0)
			{ /* se non lo  inserisci la variabile in coda */
		      formu=new formula;
	          formu->tipo_elemento=VARIABILE;
              formu->var=new variabile;
		      formu->var->nome=variabili[j].nome;
              formu->var->posizione_bit=variabili[j].posizione_bit;
	          formu->var->numero_iterazione=variabili[j].numero_iterazione;
	          formu->var->numero_blocco=variabili[j].numero_blocco;
	          formu->var->negata=variabili[j].negata;
		      formu->succ=0;
		      formu1->succ=formu;
		      formu1=formu;
			}
	        else
			{ /* se lo  crea parte destra */
		      def->parte_destra=new formula;
	          def->parte_destra->tipo_elemento=VARIABILE;
	          def->parte_destra->var=new variabile;
		      def->parte_destra->var->nome=variabili[j].nome;
		      def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	          def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	          def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	          def->parte_destra->var->negata=variabili[j].negata;
		      def->parte_destra->succ=0;
	          formu1=def->parte_destra;
	        }
	        j=j+1;
         }
	     xor->next=0;
	     ultimo_xor=xor;
	     return;
	   }
	   /* se non  vuota aggiungi la formula in coda */
	   definizioni_xor=new lista_xor;
	   definizioni_xor->formula_xor=new definizione;
	   def=definizioni_xor->formula_xor;
	   def->parte_sinistra=new formula;
       formu=def->parte_sinistra;
	   formu->tipo_elemento=VARIABILE;
       formu->var=new variabile;
	   formu->var->nome=variabili[0].nome;
	   formu->var->posizione_bit=variabili[0].posizione_bit;
	   formu->var->numero_iterazione=variabili[0].numero_iterazione;
	   formu->var->numero_blocco=variabili[0].numero_blocco;
	   formu->var->negata=variabili[0].negata;
	   formu->succ=0;
	   j=1;
	   def->parte_destra=0;
	   while(variabili[j].nome!=0)
	   {  /* verifica se la parte destra  vuota */
	      if(def->parte_destra!=0)
	      { /* se non lo  inserisci la variabile in coda */
	        formu=new formula;
	        formu->tipo_elemento=VARIABILE;
            formu->var=new variabile;
	        formu->var->nome=variabili[j].nome;
            formu->var->posizione_bit=variabili[j].posizione_bit;
	        formu->var->numero_iterazione=variabili[j].numero_iterazione;
	        formu->var->numero_blocco=variabili[j].numero_blocco;
	        formu->var->negata=variabili[j].negata;
		    formu->succ=0;
		    formu1->succ=formu;
		    formu1=formu;
	      }
	      else
	      { /* se lo  crea parte destra */
	        def->parte_destra=new formula;
	        def->parte_destra->tipo_elemento=VARIABILE;
	        def->parte_destra->var=new variabile;
	        def->parte_destra->var->nome=variabili[j].nome;
	        def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	        def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	        def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	        def->parte_destra->var->negata=variabili[j].negata;
	    	def->parte_destra->succ=0;
	        formu1=def->parte_destra;
	      }
	      j=j+1;
       }
	   definizioni_xor->next=0;
	   ultimo_xor->next=definizioni_xor;
	   ultimo_xor=definizioni_xor;
	   return;
     /* inserisci nella lista contenente le formule OR  */
	 case 2:
	   /* verifica se la lista  vuota */
	   if(or==0)
	   { /* se  vuota crea la lista */
	     or=new lista_or;
	     or->formula_or=new definizione;
	     def=or->formula_or;
	     def->parte_sinistra=new formula;
         formu=def->parte_sinistra;
	     formu->tipo_elemento=VARIABILE;
         formu->var=new variabile;
	     formu->var->nome=variabili[0].nome;
	     formu->var->posizione_bit=variabili[0].posizione_bit;
	     formu->var->numero_iterazione=variabili[0].numero_iterazione;
	     formu->var->numero_blocco=variabili[0].numero_blocco;
	     formu->var->negata=variabili[0].negata;
	     formu->succ=0;
	     j=1;
	     def->parte_destra=0;
	     while(variabili[j].nome!=0)
	     {  /* verifica se la parte destra  vuota */
	        if(def->parte_destra!=0)
			{ /* se non lo  inserisci la variabile in coda */
			  formu=new formula;
	          formu->tipo_elemento=VARIABILE;
              formu->var=new variabile;
		      formu->var->nome=variabili[j].nome;
              formu->var->posizione_bit=variabili[j].posizione_bit;
	          formu->var->numero_iterazione=variabili[j].numero_iterazione;
	          formu->var->numero_blocco=variabili[j].numero_blocco;
	          formu->var->negata=variabili[j].negata;
		      formu->succ=0;
		      formu1->succ=formu;
		      formu1=formu;
			}
	        else
			{ /* se lo  crea parte destra */
		      def->parte_destra=new formula;
	          def->parte_destra->tipo_elemento=VARIABILE;
	          def->parte_destra->var=new variabile;
		      def->parte_destra->var->nome=variabili[j].nome;
		      def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	          def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	          def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	          def->parte_destra->var->negata=variabili[j].negata;
		      def->parte_destra->succ=0;
	          formu1=def->parte_destra;
	        }
	        j=j+1;
         }
	     or->next=0;
	     ultimo_or=or;
	     return;
	   }
	   /* se non  vuota aggiungi la formula in coda */
	   definizioni_or=new lista_or;
	   definizioni_or->formula_or=new definizione;
	   def=definizioni_or->formula_or;
	   def->parte_sinistra=new formula;
       formu=def->parte_sinistra;
	   formu->tipo_elemento=VARIABILE;
       formu->var=new variabile;
	   formu->var->nome=variabili[0].nome;
	   formu->var->posizione_bit=variabili[0].posizione_bit;
	   formu->var->numero_iterazione=variabili[0].numero_iterazione;
	   formu->var->numero_blocco=variabili[0].numero_blocco;
	   formu->var->negata=variabili[0].negata;
	   formu->succ=0;
	   j=1;
	   def->parte_destra=0;
	   while(variabili[j].nome!=0)
	   {  /* verifica se la parte destra  vuota */
	      if(def->parte_destra!=0)
	      { /* se non lo  inserisci la variabile in coda */
	        formu=new formula;
	        formu->tipo_elemento=VARIABILE;
            formu->var=new variabile;
	        formu->var->nome=variabili[j].nome;
            formu->var->posizione_bit=variabili[j].posizione_bit;
	        formu->var->numero_iterazione=variabili[j].numero_iterazione;
	        formu->var->numero_blocco=variabili[j].numero_blocco;
	        formu->var->negata=variabili[j].negata;
		    formu->succ=0;
	    	formu1->succ=formu;
		    formu1=formu;
	      }
	      else
	      { /* se lo  crea parte destra */
	        def->parte_destra=new formula;
	        def->parte_destra->tipo_elemento=VARIABILE;
	        def->parte_destra->var=new variabile;
	        def->parte_destra->var->nome=variabili[j].nome;
	        def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	        def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	        def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	        def->parte_destra->var->negata=variabili[j].negata;
		    def->parte_destra->succ=0;
	        formu1=def->parte_destra;
	      }
	      j=j+1;
       }
	   definizioni_or->next=0;
	   ultimo_or->next=definizioni_or;
	   ultimo_or=definizioni_or;
	   return;
     /* inserisci nella lista contenente le formule AND */
	 case 3:
	   /* verifica se la lista  vuota */
	   if(and==0)
	   { /* se  vuota crea la lista */
	     and=new lista_and;
	     and->formula_and=new definizione;
	     def=and->formula_and;
	     def->parte_sinistra=new formula;
         formu=def->parte_sinistra;
	     formu->tipo_elemento=VARIABILE;
         formu->var=new variabile;
	     formu->var->nome=variabili[0].nome;
	     formu->var->posizione_bit=variabili[0].posizione_bit;
	     formu->var->numero_iterazione=variabili[0].numero_iterazione;
	     formu->var->numero_blocco=variabili[0].numero_blocco;
	     formu->var->negata=variabili[0].negata;
	     formu->succ=0;
	     j=1;
	     def->parte_destra=0;
	     while(variabili[j].nome!=0)
	     {  /* verifica se la parte destra  vuota */
	        if(def->parte_destra!=0)
			{ /* se non lo  inserisci la variabile in coda */
		      formu=new formula;
	          formu->tipo_elemento=VARIABILE;
              formu->var=new variabile;
		      formu->var->nome=variabili[j].nome;
              formu->var->posizione_bit=variabili[j].posizione_bit;
	          formu->var->numero_iterazione=variabili[j].numero_iterazione;
	          formu->var->numero_blocco=variabili[j].numero_blocco;
	          formu->var->negata=variabili[j].negata;
		      formu->succ=0;
		      formu1->succ=formu;
		      formu1=formu;
			}
	        else
			{ /* se lo  crea parte destra */
		      def->parte_destra=new formula;
	          def->parte_destra->tipo_elemento=VARIABILE;
	          def->parte_destra->var=new variabile;
		      def->parte_destra->var->nome=variabili[j].nome;
		      def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	          def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	          def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	          def->parte_destra->var->negata=variabili[j].negata;
		      def->parte_destra->succ=0;
	          formu1=def->parte_destra;
	        }
	        j=j+1;
         }
	     and->next=0;
	     ultimo_and=and;
	     return;
	   }
	   /* se non  vuota aggiungi la formula in coda */
	   definizioni_and=new lista_and;
	   definizioni_and->formula_and=new definizione;
	   def=definizioni_and->formula_and;
	   def->parte_sinistra=new formula;
       formu=def->parte_sinistra;
	   formu->tipo_elemento=VARIABILE;
       formu->var=new variabile;
	   formu->var->nome=variabili[0].nome;
	   formu->var->posizione_bit=variabili[0].posizione_bit;
	   formu->var->numero_iterazione=variabili[0].numero_iterazione;
	   formu->var->numero_blocco=variabili[0].numero_blocco;
	   formu->var->negata=variabili[0].negata;
	   formu->succ=0;
	   j=1;
	   def->parte_destra=0;
	   while(variabili[j].nome!=0)
	   {  /* verifica se la parte destra  vuota */
	      if(def->parte_destra!=0)
	      { /* se non lo  inserisci la variabile in coda */
	        formu=new formula;
	        formu->tipo_elemento=VARIABILE;
            formu->var=new variabile;
	        formu->var->nome=variabili[j].nome;
            formu->var->posizione_bit=variabili[j].posizione_bit;
	        formu->var->numero_iterazione=variabili[j].numero_iterazione;
	        formu->var->numero_blocco=variabili[j].numero_blocco;
	        formu->var->negata=variabili[j].negata;
		    formu->succ=0;
		    formu1->succ=formu;
		    formu1=formu;
	      }
	      else
	      { /* se lo  crea parte destra */
	        def->parte_destra=new formula;
	        def->parte_destra->tipo_elemento=VARIABILE;
	        def->parte_destra->var=new variabile;
	        def->parte_destra->var->nome=variabili[j].nome;
	        def->parte_destra->var->posizione_bit=variabili[j].posizione_bit;
	        def->parte_destra->var->numero_iterazione=variabili[j].numero_iterazione;
	        def->parte_destra->var->numero_blocco=variabili[j].numero_blocco;
	        def->parte_destra->var->negata=variabili[j].negata;
		    def->parte_destra->succ=0;
	        formu1=def->parte_destra;
	      }
	      j=j+1;
       }
	   definizioni_and->next=0;
	   ultimo_and->next=definizioni_and;
	   ultimo_and=definizioni_and;
	   return;
	}
}

/* Funzione che inserisce nella lista xor le formule del tipo:
   X = E xor K, dove E sono le variabili R permutate            */
void scrivi_in_lista(int* E, int* chiave, int i, int k, int num_bl_key)
{	int j;
	lista_xor* definizioni_xor;
	definizione* def;
	formula* formu;
	formula* formu1;
	for(j=0;j<48;j++)
	{  /* verifica se la lista  vuota */
	   if(xor==0)
	   { /* se lo  la lista viene creata */
	     xor=new lista_xor;
	     xor->formula_xor=new definizione;
	     def=xor->formula_xor;
	     def->parte_sinistra=new formula;
         formu=def->parte_sinistra;
	     formu->tipo_elemento=VARIABILE;
         formu->var=new variabile;
	     formu->var->nome='X';
	     formu->var->posizione_bit=j+1;
	     formu->var->numero_iterazione=i;
	     formu->var->numero_blocco=k;
	     formu->var->negata=0;
	     formu->succ=0;
	     def->parte_destra=new formula;
	     def->parte_destra->tipo_elemento=VARIABILE;
	     def->parte_destra->var=new variabile;
	     def->parte_destra->var->nome='R';
	     def->parte_destra->var->posizione_bit=E[j];
	     def->parte_destra->var->numero_iterazione=i-1;
	     def->parte_destra->var->numero_blocco=k;
	     def->parte_destra->var->negata=0;
	     def->parte_destra->succ=0;
	     formu1=def->parte_destra;
	     formu=new formula;
	     formu->tipo_elemento=VARIABILE;
         formu->var=new variabile;
	     formu->var->nome='K';
         formu->var->posizione_bit=chiave[j];
	     formu->var->numero_iterazione=0;
	     formu->var->numero_blocco=num_bl_key;
	     formu->var->negata=0;
	     formu->succ=0;
	     formu1->succ=formu;
	     formu1=formu;
	     xor->next=0;
	     ultimo_xor=xor;
	   }
	   else{
       /* se non lo  l'elememto viene inserito in coda */
	   definizioni_xor=new lista_xor;
	   definizioni_xor->formula_xor=new definizione;
	   def=definizioni_xor->formula_xor;
	   def->parte_sinistra=new formula;
       formu=def->parte_sinistra;
	   formu->tipo_elemento=VARIABILE;
       formu->var=new variabile;
	   formu->var->nome='X';
	   formu->var->posizione_bit=j+1;
	   formu->var->numero_iterazione=i;
	   formu->var->numero_blocco=k;
	   formu->var->negata=0;
	   formu->succ=0;
	   def->parte_destra=new formula;
	   def->parte_destra->tipo_elemento=VARIABILE;
	   def->parte_destra->var=new variabile;
	   def->parte_destra->var->nome='R';
	   def->parte_destra->var->posizione_bit=E[j];
	   def->parte_destra->var->numero_iterazione=i-1;
	   def->parte_destra->var->numero_blocco=k;
	   def->parte_destra->var->negata=0;
	   def->parte_destra->succ=0;
	   formu1=def->parte_destra;
	   formu=new formula;
	   formu->tipo_elemento=VARIABILE;
       formu->var=new variabile;
	   formu->var->nome='K';
       formu->var->posizione_bit=chiave[j];
	   formu->var->numero_iterazione=0;
	   formu->var->numero_blocco=num_bl_key;
	   formu->var->negata=0;
	   formu->succ=0;
	   formu1->succ=formu;
	   formu1=formu;
	   definizioni_xor->next=0;
	   ultimo_xor->next=definizioni_xor;
	   ultimo_xor=definizioni_xor;
	   }
	}  
}

/* Funzione che inserisce nella lista identita formule del tipo:
   F = P, dove P sono le variabili S permutate                   */
void scrivi_in_lista(int* P,int i,int k)
{	int j;
	lista_identita* definizioni_identita;
	definizione* def;
	formula* formu;
	for(j=0;j<32;j++)
	{  /* verifica se la lista  vuota */
	   if(identity==0)
	   { /* se lo  viene creata la lista */
	     identity=new lista_identita;
	     identity->identita=new definizione;
	     def=identity->identita;
	     def->parte_sinistra=new formula;
         formu=def->parte_sinistra;
	     formu->tipo_elemento=VARIABILE;
         formu->var=new variabile;
	     formu->var->nome='F';
	     formu->var->posizione_bit=j+1;
	     formu->var->numero_iterazione=i;
	     formu->var->numero_blocco=k;
	     formu->var->negata=0;
	     formu->succ=0;
	     def->parte_destra=new formula;
	     def->parte_destra->tipo_elemento=VARIABILE;
	     def->parte_destra->var=new variabile;
	     def->parte_destra->var->nome='S';
	     def->parte_destra->var->posizione_bit=P[j];
	     def->parte_destra->var->numero_iterazione=i;
	     def->parte_destra->var->numero_blocco=k;
	     def->parte_destra->var->negata=0;
	     def->parte_destra->succ=0;
	     identity->next=0;
	     ultimo=identity;
	   }
	   else{
       /* se non lo  l'elemento viene inserito in coda */
	   definizioni_identita=new lista_identita;
	   definizioni_identita->identita=new definizione;
	   def=definizioni_identita->identita;
	   def->parte_sinistra=new formula;
       formu=def->parte_sinistra;
	   formu->tipo_elemento=VARIABILE;
       formu->var=new variabile;
	   formu->var->nome='F';
	   formu->var->posizione_bit=j+1;
	   formu->var->numero_iterazione=i;
	   formu->var->numero_blocco=k;
	   formu->var->negata=0;
	   formu->succ=0;
	   def->parte_destra=new formula;
	   def->parte_destra->tipo_elemento=VARIABILE;
	   def->parte_destra->var=new variabile;
	   def->parte_destra->var->nome='S';
	   def->parte_destra->var->posizione_bit=P[j];
	   def->parte_destra->var->numero_iterazione=i;
	   def->parte_destra->var->numero_blocco=k;
	   def->parte_destra->var->negata=0;
	   def->parte_destra->succ=0;
	   definizioni_identita->next=0;
	   ultimo->next=definizioni_identita;
	   ultimo=definizioni_identita;
	   }
	}
}