/* permuta.c: modulo che effettua la permutazione iniziale del plaintext, e quella
   finale inversa sul ciphertext */


#include "permuta.h"
#include "leggi_pd.h"
#include "leggi_pi.h"


// Vettore che descrive la permutazione da applicare al plaintext
int permutazione_diretta[64];

// Vettore che descrive la permutazione da applicare al ciphertext
int permutazione_inversa[64];


// Funzione che permuta il plaintext
void permuta_plaintext(int * plaintext, int * plaintext_permutato)
{	int i,h;
	leggi_perm_dir();
	for(i=0;i<64;i++)
	{   h = permutazione_diretta[i];
		plaintext_permutato[i] = plaintext[h-1];
	}
}

// Funzione che permuta il ciphertext
void permuta_ciphertext(int * ciphertext, int * ciphertext_permutato)
{	int i,h;
	leggi_perm_inv();
	for(i=0;i<64;i++)
	{   h = permutazione_inversa[i];
		ciphertext_permutato[i] = ciphertext[h-1];
	}
}


void permutazione(int* perm)
{
	int i;
	leggi_perm_dir();
	for(i=0;i<64;i++)
		perm[i]=permutazione_diretta[i];
}
