/*  valuprop.c: modulo che realizza il valutatore proposizionale */

#include <stdio.h>
#include "strutt.h"
#include "comune.h"

extern lista_xor* xor;
extern lista_and* and;
extern lista_or* or;

/*************************** Prototipi funzioni **************************/
void normal_xor(&int);
void normal_and(&int);
void normal_or(&int);

void agg_lista_identita(definizione*);
/************************************************************************/

void normalizza(int& cambiato)
{	normal_xor(cambiato);
	normal_and(cambiato);
	normal_or(cambiato);
}

void normal_xor(int& cambiato)
{
  lista_xor* scorri_xor;
  lista_xor* precedente;

  scorri_xor=xor;
  precedente=xor;
  while(scorri_xor!=0) { 
    if(scorri_xor->formula_xor->parte_sinistra->var->negata) {
      cambiato=1;
      scorri_xor->formula_xor->parte_sinistra->var->negata=0;
      if (scorri_xor->formula_xor->parte_destra->succ->var->negata)
	scorri_xor->formula_xor->parte_destra->var->negata=1;
      else
	scorri_xor->formula_xor->parte_destra->var->negata=0;
    scorri_xor=scorri_xor->next;
    }
  }
}

void normal_and(int& cambiato)
{	
  lista_and* prece;
  lista_and* scorri_and;
  lista_or* new_lista_or;

  scorri_and=and;
  prece=and;
  while(scorri_and!=0) { 
    if(scorri_and->formula_and->parte_sinistra->var->negata) { 
      cambiato=1;
      demorgan(scorri_and->formula_and->parte_sinistra);
      demorgan(scorri_and->formula_and->parte_destra);
      new_lista_or = new lista_or;
      new_lista_or->formula_or=new definizione;
      new_lista_or->formula_or->parte_sinistra=scorri_and->formula_and->parte_sinistra;
      new_lista_or->formula_or->parte_destra=scorri_and->formula_and->parte_destra;
      new_lista_or->next=or;
      or=new_lista_or;
      scorri_or->formula_or->parte_sinistra=0;
      scorri_or->formula_or->parte_destra=0;
      if(scorri_and!=prece)
	prece->next=scorri_and->next; 
      else {
	prece=scorri_and->next;
	and=scorri_and->next;
      }
    }
    else
      prece=scorri_and;
    scorri_and=scorri_and->next;
  }
}

void valuta_or(int& cambiato)
{	
  lista_or* prece;
  lista_or* scorri_or;
  lista_and* new_lista_and;

  scorri_or=or;
  prece=or;
  while(scorri_or!=0) { 
    if(scorri_or->formula_or->parte_sinistra->var->negata) { 
      cambiato=1;
      demorgan(scorri_or->formula_or->parte_sinistra);
      demorgan(scorri_or->formula_or->parte_destra);
      new_lista__and = new lista_and;
      new_lista_and->formula_and=new definizione;
      new_lista_and->formula_and->parte_sinistra=scorri_or->formula_or->parte_sinistra;
      new_lista_and->formula_and->parte_destra=scorri_or->formula_or->parte_destra;
      new_lista_and->next=and;
      and=new_lista_and;
      scorri_or->formula_or->parte_sinistra=0;
      scorri_or->formula_or->parte_destra=0;
      if(scorri_or!=prece)
	prece->next=scorri_or->next; 
      else {
	prece=scorri_or->next;
	or=scorri_or->next;
      }
    }
    else
      prece=scorri_or;
    scorri_or=scorri_or->next;
  }
}

/* Se def e' un'identita' la aggiunge alla lista delle identita' */
void demorgan(formula* A)
{   
  formula B;

  for (B=A; B!=0; B=B->succ) {
    if (B->var->negata)
      B->var->negata=0;
    else
      B->var->negata=1;
  }
}
