/* minimiz.c: modulo che procede all'eliminazione dei duplicati presenti
	       nelle lista contenenti le formule                          */

#include "strutt.h"
#include "minimiz.h"
#include <stdio.h>

extern lista_identita* identity;
extern lista_identita* ultimo;
extern lista_and* ultimo_and;

formula* temp11;
lista_and* scorri_lista;
lista_and* precedente;
lista_and* elemento_attuale;


/*************************** Prototipi funzioni ***************************/
lista_and* elimina_duplicati(lista_and*);/* lista_and=lista da cui devono
					    essere eliminati i duplicati  */
void verifica(definizione*,definizione*);
int appartiene(variabile*);
int diversi(formula*,formula*);
void aggiungi_lista_identita(definizione*);
/**************************************************************************/

/* Funzione che elimina i duplicati, eventualmente presenti, in lis.
   Si occupa altresi' di spostare eventuali identita', create durante tale
   fase, nella lista contenente le identita'. Come risultato fornisce una
   lista in cui non sono presenti duplicati.                              */
lista_and* elimina_duplicati(lista_and* lis)
{	elemento_attuale=lis;
	while(elemento_attuale!=(lista_and*)NULL)
	{  if(elemento_attuale->formula_and->parte_destra->succ!=0)
	   {  scorri_lista=lis;
	      while(scorri_lista!=(lista_and*)NULL)
	      {  if(scorri_lista!=elemento_attuale)
		    verifica(scorri_lista->formula_and,	elemento_attuale->formula_and);
	         precedente=scorri_lista;
	         scorri_lista=scorri_lista->next;
	      }
	   }
	   elemento_attuale=elemento_attuale->next;
	}
	scorri_lista=lis;
	precedente=lis;
	while(scorri_lista!=(lista_and*)NULL)
	{ if(scorri_lista->formula_and->parte_destra->succ==0)
	  /* se parte destra e' composta da una sola variabile allora ho
	     un'identita' che devo aggiungere alla lista delle identita' */
	  {  aggiungi_lista_identita(scorri_lista->formula_and);
             if(scorri_lista!=precedente)
	     /* se quello attuale non e' il primo elemento della lista,
		 allora per eliminare l'identita' dalla lista
		 precedente->next puntera' allo stesso elemento cui puntera'
		 scorri alla prossima iterazione                          */       
		      precedente->next=scorri_lista->next; 
	     else
	     /* altrimenti precedente puntera' allo stesso elemento cui
		 puntera' scorri nella prossima iterazione e dalla lista che
		 stiamo esaminando verra' eliminato il primo elemento     */
	     {	precedente=scorri_lista->next;
		lis=scorri_lista->next;
	     }
	  }
	  /* in caso contrario si dovra' solo avanzare il puntatore che
	     punta all'elemento precedente                               */
	  else precedente=scorri_lista;
	  /* in ogni caso si passa ad analizzare l'elemento successivo   */
	  scorri_lista=scorri_lista->next;
	}
	ultimo_and=precedente;  
	return lis;
}

/* Verifica se elem e' contenuto nell'elemento attualmente puntato da
   scorri.                                                            */
void verifica(definizione* scorri, definizione* elem)
{	formula* temp;
        formula* nuova_parte;
	temp=elem->parte_destra;
	temp11=scorri->parte_destra;
	/* la verifica di appartenenza e' effettuata controllando che tutte
	   le variabili di elem siano contenute nell'elemento corrente    */
	while(temp!=(formula*)NULL)
	{  if(!appartiene(temp->var))
		return;
	   temp=temp->succ;
	}
	/* se arrivo qui significa che elem e' contenuto nell'elemento
	   attuale.                                                    */
	temp=temp11;
	/* la nuova parte destra di scorri e' creata aggiungendo agli
	   elementi della vecchia parte destra di scorri non contenuti in 
           elem, la parte sinistra di elem.                               */
	if(temp!=(formula*)NULL)
	{  while(temp->succ!=0)
		 temp=temp->succ;
	   nuova_parte=new formula;
	   nuova_parte->tipo_elemento=elem->parte_sinistra->tipo_elemento;
	   nuova_parte->succ=(formula*)NULL;
           if(elem->parte_sinistra->tipo_elemento!=VARIABILE)
	      nuova_parte->var=(variabile*)NULL;
	   else 
	   {  nuova_parte->var=new variabile;
	      nuova_parte->var->nome=elem->parte_sinistra->var->nome;
	      nuova_parte->var->posizione_bit=elem->parte_sinistra->var->posizione_bit;
	      nuova_parte->var->numero_iterazione=elem->parte_sinistra->var->numero_iterazione;
	      nuova_parte->var->numero_blocco=elem->parte_sinistra->var->numero_blocco;
	      nuova_parte->var->negata=elem->parte_sinistra->var->negata;
	   }
	   temp->succ=nuova_parte;
	}
	else
	{  nuova_parte=new formula;
	   nuova_parte->tipo_elemento=elem->parte_sinistra->tipo_elemento;
	   nuova_parte->succ=(formula*)NULL;
           if(elem->parte_sinistra->tipo_elemento!=VARIABILE)
	      nuova_parte->var=(variabile*)NULL;
	   else 
	   {  nuova_parte->var=new variabile;
	      nuova_parte->var->nome=elem->parte_sinistra->var->nome;
	      nuova_parte->var->posizione_bit=elem->parte_sinistra->var->posizione_bit;
	      nuova_parte->var->numero_iterazione=elem->parte_sinistra->var->numero_iterazione;
	      nuova_parte->var->numero_blocco=elem->parte_sinistra->var->numero_blocco;
	      nuova_parte->var->negata=elem->parte_sinistra->var->negata;
	   }
	   temp11=nuova_parte;
	}
	scorri->parte_destra=temp11;
}

/* Verifica se la variabile vari e' contenuta all'interno della lista di
   elementi puntata da form(=temp11:parte destra di una formula).         */
int appartiene(variabile* vari)
{	formula* form;
	formula* temp2=(formula*)NULL;
	formula* fine=(formula*)NULL;
	int trovato=0;
	form=temp11;
	/* verifica se la variabile vari  contenuta in form. */
	while(form!=(formula*)NULL)
	{  if(!((form->var->nome==vari->nome)&&
		(form->var->posizione_bit==vari->posizione_bit)&&
		(form->var->numero_iterazione==vari->numero_iterazione)&&
		(form->var->numero_blocco==vari->numero_blocco)&&
		(form->var->negata==vari->negata)))
	   {  /* se vari e' diversa dall'elemento attuale di form poni
                 tale elemento nella lista degli elementi restanti.     */
	      if(temp2!=(formula*)NULL)
	      { formula* form1=new formula;
		form1->tipo_elemento=form->tipo_elemento;
                form1->var=new variabile;
	        form1->var->nome=form->var->nome;
	        form1->var->posizione_bit=form->var->posizione_bit;
	        form1->var->numero_iterazione=form->var->numero_iterazione;
		form1->var->numero_blocco=form->var->numero_blocco;
	        form1->var->negata=form->var->negata;
		form1->succ=(formula*)NULL;
	        fine->succ=form1;
		fine=form1;
              }
	      else 
	      {  temp2=new formula;
		 temp2->tipo_elemento=form->tipo_elemento;
		 temp2->var=new variabile;
		 temp2->var->nome=form->var->nome;
		 temp2->var->posizione_bit=form->var->posizione_bit;
		 temp2->var->numero_iterazione=form->var->numero_iterazione;
		 temp2->var->numero_blocco=form->var->numero_blocco;
		 temp2->var->negata=form->var->negata;
		 temp2->succ=(formula*)NULL;
		 fine=temp2;
              }
	   }
	   else /* se vari e' contenuta poni trovato ad 1 */
   	       trovato=1;
	   form=form->succ;
	}
	temp11=temp2;
	return trovato;
}

/* Se def e' un'identit la aggiunge alla lista delle identita' */
void aggiungi_lista_identita(definizione* def)
{   lista_identita* id;
    id=new lista_identita;
    id->identita=new definizione;
    id->identita=def;
    id->next=(lista_identita*)NULL;
    if(ultimo!=(lista_identita*)NULL)
       ultimo->next=id;
    else
       identity=id;
    ultimo=id;
}
