#include <stdio.h>
#include <stdlib.h>

/* converte in binario il numero esadecimale contenuto nel vettore
   esadecimale[8] (questo vettore accoglie il numero esadecimale spezzato
   in coppie di numeri: ad esempio il numero 0x1234 viene inserito come
   0x12 - 0x34). In numeri esadecimali sono poi rovesciati (esempio 0x21 - 0x43)
   e tradotti in codifica binaria. Tale numero binario viene inserito 
   nel vettore binkey[] */

void converti(int esadecimale[], int* binkey)
{
  int count=0;
  int n,h,k,esa,esa1,esa2,esad;
  
  for(n=0;n<8;n++) {
    esa=(int)esadecimale[n];
    esa1=(esa&0x0F);
    esa2=((esa&0xF0)>>4);
    for(h=0;h<2;h++) {
      switch(h) {
      case 0:
	esad=esa2;
	break;
      case 1:
	esad=esa1;
	break;
      }
      for(k=0;k<4;k++) {
	switch(esad) {
	case 0:
	  binkey[count]=0;
	  binkey[count+1]=0;
	  binkey[count+2]=0;
	  binkey[count+3]=0;
	  break;
	case 1:
	  binkey[count]=0;
	  binkey[count+1]=0;
	  binkey[count+2]=0;
	  binkey[count+3]=1;
	  break;
	case 2:
	  binkey[count]=0;
	  binkey[count+1]=0;
	  binkey[count+2]=1;
	  binkey[count+3]=0;
	  break;
	case 3:
	  binkey[count]=0;
	  binkey[count+1]=0;
	  binkey[count+2]=1;
	  binkey[count+3]=1;
	  break;
	case 4:
	  binkey[count]=0;
	  binkey[count+1]=1;
	  binkey[count+2]=0;
	  binkey[count+3]=0;
	  break;
	case 5:
	  binkey[count]=0;
	  binkey[count+1]=1;
	  binkey[count+2]=0;
	  binkey[count+3]=1;
	  break;
	case 6:
	  binkey[count]=0;
	  binkey[count+1]=1;
	  binkey[count+2]=1;
	  binkey[count+3]=0;
	  break;
	case 7:
	  binkey[count]=0;
	  binkey[count+1]=1;
	  binkey[count+2]=1;
	  binkey[count+3]=1;
	  break;
	case 8:
	  binkey[count]=1;
	  binkey[count+1]=0;
	  binkey[count+2]=0;
	  binkey[count+3]=0;
	  break;
	case 9:
	  binkey[count]=1;
	  binkey[count+1]=0;
	  binkey[count+2]=0;
	  binkey[count+3]=1;
	  break;
	case 10:
	  binkey[count]=1;
	  binkey[count+1]=0;
	  binkey[count+2]=1;
	  binkey[count+3]=0;
	  break;
	case 11:
	  binkey[count]=1;
	  binkey[count+1]=0;
	  binkey[count+2]=1;
	  binkey[count+3]=1;
	  break;
	case 12:
	  binkey[count]=1;
	  binkey[count+1]=1;
	  binkey[count+2]=0;
	  binkey[count+3]=0;
	  break;
	case 13:
	  binkey[count]=1;
	  binkey[count+1]=1;
	  binkey[count+2]=0;
	  binkey[count+3]=1;
	  break;
	case 14:
	  binkey[count]=1;
	  binkey[count+1]=1;
	  binkey[count+2]=1;
	  binkey[count+3]=0;
	  break;
	case 15:
	  binkey[count]=1;
	  binkey[count+1]=1;
	  binkey[count+2]=1;
	  binkey[count+3]=1;
	  break;
	}
      }
      count +=4;
    }
  }
}
 
void main() {
  int key[64];
  int k[8];
  int i;
  FILE* key_des;
  FILE* chiave;
  
  if((key_des=fopen("key_des","r"))==NULL)  {
    printf("Errore: file key_des inesistente\n");
    exit(1);
  }

  for(i=0;i<8;i++)
    fscanf(key_des,"%4x",&(k[i]));
  fclose(key_des);

  if((chiave=fopen("chiave","w"))==NULL) {
    printf("Errore: impossibile creare il file chiave\n");
    exit(1);
  }

  converti(k,key);

/*  for(i=0;i<8;i++) {
    fprintf(chiave,"%4x ",k[i]);
  }
*/ 
  fprintf(chiave,"\n");

  for(i=0;i<64;i++) {
    fprintf(chiave,"K%d=%d",i+1,key[i]);
    if(i!=63)
      fprintf(chiave,"\n");
  }
  
  fclose(chiave);
}
