/* des_1.c: modulo che realizza DES */

#include "permuta.h"
#include "esa_bin.h"
#include "des.h"
#include "leg_Sbox.h"
#include "leggi_E.h"
#include "leggi_P.h"
#include "leggi_pp.h"
#include "leggi_sh.h"
#include "leggi_sp.h"
#include <stdio.h>

int chiave_permutata_des[56]; /* contiene i 56 bits significativi permutati */

/* I vettori successivi permettono di implementare l'algoritmo di
   manipolazione della chiave */
static int c_des[28]; /* Svolge le funzioni dell'omonimo vettore c di DES   */
static int d_des[28]; /* Svolge le funzioni dell'omonimo vettore d di DES   */

int temp1_des[28];
int temp2_des[28];
int chiave_shiftata_des[56]; /* Contiene i 56 bits della chiave che hanno
			                    subito la prima permutazione e la/le
			                    operazione/i di shift                       */ 


/* Il vettore successivo indica il numero di shift da effettuare per
   ciascuna iterazione */
int numero_shift[16];

/* I seguenti due vettori indicano le due permutazioni che devono essere
   eseguite sulla chiave */
int prima_permutazione[56];
int seconda_permutazione[48];

/* Vettore usato per estendere R */
int E[48];

/* Matrici che rappresentano le S-boxes di DES  */
int S1[4][16];
int S2[4][16];
int S3[4][16];
int S4[4][16];
int S5[4][16];
int S6[4][16];
int S7[4][16];
int S8[4][16];
/* Vettore utilizzato per permutare i 32 bits uscenti dalle S-boxes */
int P[32];

/*********************** Prototipi funzioni *************************/
void f(int*,int*,int,int*);
void des(int*,int*,int,int*);
void permuta_chiave_des(int*);
void effettua_shift_des(int);
void fornisci_chiave_des(int,int*,int*);
/********************************************************************/

/* Funzione che realizza DES */
void des(int* plain, int* K, int n, int* cipher)
{	int plain_permutato[64];
	int Lprec[32];
	int Rprec[32];
	int Lattuale[32];
	int Rattuale[32];
	int F[32];
	int preoutput[64];
    int i,j;
	leggi_E();
	leggi_prima_permutazione();
	leggi_shift();
	leggi_seconda_permutazione();
	leggi_P();
	leggi_Sbox(1);
	leggi_Sbox(2);
	leggi_Sbox(3);
	leggi_Sbox(4);
	leggi_Sbox(5);
	leggi_Sbox(6);
	leggi_Sbox(7);
	leggi_Sbox(8);
	/* permuta il plaintext */
	permuta_plaintext(plain,plain_permutato);
	for(i=0;i<32;i++)
	{  Lprec[i]=plain_permutato[i];
	   Rprec[i]=plain_permutato[32+i];
	}
    /* esegui le n iterazioni per la codifica del plaintext */
	for(i=1;i<=n;i++)
	{  f(Rprec,K,i,F);
	   for(j=0;j<32;j++)
	   {  Lattuale[j]=Rprec[j];
	      if(Lprec[j]==F[j])
		     Rattuale[j]=0;
	      else Rattuale[j]=1;
	      Rprec[j]=Rattuale[j];
	      Lprec[j]=Lattuale[j];
	   }
	}
    /* prepara il preoutput */
    if(n!=0)
    /* inverti la parte destra con quella sinistra */
	   for(i=0;i<32;i++)
		{  preoutput[i]=Rprec[i];
	       preoutput[32+i]=Lprec[i]; }
	else
    /* non invertire le due parti */
	  for(i=0;i<32;i++)
	  {  preoutput[i]=Lprec[i];
	     preoutput[32+i]=Rprec[i]; }
	/* effettua la permutazione sul preoutput */
	permuta_ciphertext(preoutput,cipher);
}


/* Effettua la permutazione iniziale sulla chiave (tale permutazione riduce
   altres i bits a 56), e spezza tale permutazione in due parti */
void permuta_chiave_des(int* chiave)
{	int i, /* Variabile usata come indice nei cicli */
        h; /* Variabile di appoggio                 */
	for(i=0;i<56;i++)
	{	h = prima_permutazione[i];
		chiave_permutata_des[i] = chiave[h-1];
	}
	for(i=0;i<28;i++)
		c_des[i] = chiave_permutata_des[i];
    for(i=28;i<56;i++)
		d_des[i-28] = chiave_permutata_des[i];

}

/* Effettua l'operazione di shift.
   Tale operazione viene cos effettuata:
      1) Per ciascuno dei 28 bits di c e d, calcola la posizione (k)
	     che ciascun bit andr ad occupare dopo lo shift. Se tale
	     valore  negativo, allora per calcolare la posizione si
	     dovr sommare algebricamente tale valore a 27 (in C++
	     i vettori partono da zero);
      2) Effettua lo shift;
      3) Unisci le due parti in un unico vettore;
      4) Aggiorna c e d.                                             */
void effettua_shift_des(int n) /* n rappresenta l'iterazione per cui serve
                                  la chiave                              */
{	int i, /* Variabile usata come indice nei cicli */
	    k;
    for(i=0;i<28;i++)
	{	k=(i+1-numero_shift[n-1]);
		if(k<=0)
		{   temp1_des[27+k] = c_des[i];
            temp2_des[27+k] = d_des[i];   }
		else { temp1_des[k-1] = c_des[i];
		       temp2_des[k-1] = d_des[i]; }
        }
	for(i=0;i<28;i++)
	{	chiave_shiftata_des[i] = temp1_des[i];
		chiave_shiftata_des[28+i] = temp2_des[i];
		c_des[i] = temp1_des[i];
		d_des[i] = temp2_des[i];
	}
}

/* Fornisce, in base all'iterazione, la chiave necessaria a DES */
void fornisci_chiave_des(int n, int* K, int* chiave_ridotta)
/* n rappresenta l'iterazione per cui si deve calcolare la chiave,
   chiave_ridotta contiene il valore ritornato della chiave     */
{	int i,h;
	if(n==1)
       permuta_chiave_des(K); 
	effettua_shift_des(n);
	for(i=0;i<48;i++)
	{	h = seconda_permutazione[i];
		chiave_ridotta[i] = chiave_shiftata_des[h-1];
	}
}

/* funzione che realizza la funzione f di DES */
void f(int* R, int* K, int i, int* S_perm)
{   int chiave[48];
	int X[48];
	int S[32];
	int j, count, val, riga, colonna, y , resto;
	/* determina i bit della chiave utilizzati dalla
	   presente iterazione */
	fornisci_chiave_des(i,K,chiave);
    /* calcola i bits che permettono di accedere alle S-boxes */
    for(j=0;j<48;j++)
	{  if(chiave[j]==R[E[j]-1])
	      X[j]=0;
	   else X[j]=1;           
	}
	count=0;
    /* seleziona gli elementi appropriati delle S-boxes */
	for(j=1;j<=8;j++)
	{  riga=2*X[count]+X[count+5];
	   colonna=8*X[count+1]+4*X[count+2]+2*X[count+3]+X[count+4];
	   switch(j)
	   {  case 1: 
	          val=S1[riga][colonna];
		      for(y=3;y>=0;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;			 
		      }
		      break;
	      case 2: 
			  val=S2[riga][colonna];
		      for(y=7;y>=4;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;
		      }
		      break;
	      case 3: 
			  val=S3[riga][colonna];
		      for(y=11;y>=8;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;			 
		      }
		      break;
	      case 4: 
			  val=S4[riga][colonna];
		      for(y=15;y>=12;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;			 
		      }
		      break;
	      case 5: 
			  val=S5[riga][colonna];
		      for(y=19;y>=16;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;			 
		      }
		      break;
	      case 6: 
			  val=S6[riga][colonna];
		      for(y=23;y>=20;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;
		      }
		      break;
	      case 7: 
			  val=S7[riga][colonna];
		      for(y=27;y>=24;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;			 
		      }
		      break;
	      case 8: val=S8[riga][colonna];
		      for(y=31;y>=28;y--)
		      {  resto=val%2;
			     val=val/2;
			     S[y]=resto;			 
		      }
		      break;
	   }
       count=count+6;
	}
	/* permuta i bits ottenuti dalle S-boxes */
	for(j=0;j<32;j++)
	    S_perm[j]=S[P[j]-1];        
}

