/* des.c : main del programma che realizza DES */

#include "des.h"
#include "strutt.h"
#include "esa_bin.h"
#include <stdio.h>
#include <stdlib.h>

void help(int);

int main(int argc, char* argv[])
{   int plain[64];
	int key[64];
	int cipher[64];
	int n;
    int num_blocchi;
	FILE* plain_txt;
	FILE* ciph_txt;
    FILE* key_des;
	int pl[8];
	int k[8];
	int i,decimale,i1;
	int val,h;
	/* Controllo parametri inseriti */
	n=1; /* Valore di default per i round */
    num_blocchi=1; /* Valore di default per il numero dei blocchi */
    int num_bl_key=1; /* Valore di default da attribuire al blocco relativo alla chiave */
	while((--argc>0)&&(*++argv)[0]=='-')
		switch((*argv)[1]){
		case 'r':
			sscanf(*argv,"-r%d",&n);
			if((n<1)||(n>16))
		        help(1);
			break;
		case 'b':
			sscanf(*argv,"-b%d",&num_blocchi);
			if(1>num_blocchi)
				help(2);
			break;
		case 'k': 
			sscanf(*argv,"-k%d",&num_bl_key);
			if(1>num_bl_key)
				help(3);
			break;
		case 'h':
			help(0);
			break;
		default:
			printf("Illegal option use des -h for help");
			exit(1);
		}
	if((plain_txt=fopen("plaintxt","r"))==NULL)
	{  printf("Error: file plaintxt doesn't exist");
	   exit(1);
	}
	if((key_des=fopen("key_des","r"))==NULL)
	{  printf("Error: file key_des doesn't exist");
	   exit(1);
	}
	if((ciph_txt=fopen("ciph_txt","w"))==NULL)
	{  printf("Error: can't create file ciph_txt");
	   exit(1);
	}
	i=0;
	i1=0;
    printf("\n############# DES with %d round/rounds #############\n\n",n);
	/* Lettura chiave */
	for(i1=1;i1<=num_bl_key;i1++)
	if(feof(key_des)==0)
	{  for(i=0;i<8;i++)
	   {  fscanf(key_des,"%4x",&val);
	      k[i]=val&0x00ff;
	   }
	}
	else 
	{   
	    printf("Key blocks are less than %i\n",num_bl_key);
	    fclose(plain_txt);
		fclose(key_des);
		fclose(ciph_txt);
	    exit(1);
	}
	printf("Key: ");
	for(i=0;i<8;i++)
	    printf("%02x",(unsigned int)k[i]&0x00ff);
	printf("\n");
	converti(k,key);
	h=0;
	while((feof(plain_txt)==0)&&(h<num_blocchi))
	{  for(i=0;i<8;i++)
	   {  fscanf(plain_txt,"%4x",&val);
	      pl[i]=val;
	   }
	   converti(pl,plain);
	   des(plain,key,n,cipher);
	   printf("Plaintext: ");
	   for(i=0;i<8;i++)
	      printf("%02x",(unsigned int)pl[i]&0x00ff);
	   printf("\n");
	   printf("Ciphertext (after %i round/rounds): ",n);
	   for(i=0;i<64;i=i+4)
	   { decimale=8*cipher[i]+4*cipher[i+1]+2*cipher[i+2]+cipher[i+3];
	     printf("%x",decimale);
	     if((i==8)||(i==16)||(i==24)||(i==0)||(i==32)||(i==40)||
           (i==48)||(i==56))
		 {   if(i!=0)
                fprintf(ciph_txt," ");
	 	     fprintf(ciph_txt,"0x");
		 }
	     fprintf(ciph_txt,"%x",decimale);
	   }
	   printf("\n");
	   h=h+1;
	   if((h<num_blocchi)&&(feof(plain_txt)==0))
          fprintf(ciph_txt,"\n");
	}
	if(h<num_blocchi)
		printf("Plaintext blocks are less than %i\n",h);;
	fclose(plain_txt);
	fclose(key_des);
	fclose(ciph_txt);
}

void help(int tag)
{	switch(tag){
	case 0:
		printf("The program can be executed in the following manner:\n");
		printf("   des command  followed by the return ");
		printf("generates the ciphertext\n");
		printf("   for one round and with one block.\n\n");
		printf("The following options are allowed:\n");
		printf("  -r num_rounds # The rounds are num_rounds.\n");
		printf("  -b num_blocks # The blocks are num_blocks.\n");
		printf("  -k m          # Read the m-th key.\n");
		printf("  -h            # Recall this help.\n");
		break;
	case 1:
		printf("Error: The number of the iterations have to be between 1 and 16!\n");
		printf("       Use des -h for help.\n");
		break;
	case 2:
		printf("Error: The number of the blocks have to be greater than 1!\n");
		printf("       Use des -h for help.\n");
		break;
	case 3:
		printf("Error: The number associated to the key have to be greater than 1!\n");
		printf("       Use des -h for help.\n");
		break;
	}
	exit(1);
}
