/* creafile.c: Questo programma prende le S-boxes, le trasforma in binario
	       e le memorizza su files in formato tale da poter essere
	       lette da Espresso */

#include <stdio.h>
#include <stdlib.h>
#include "leggi_Sb.h"

/* Vettori che rappresentano le S-boxes di DES  */
int S1[64];
int S2[64];
int S3[64];
int S4[64];
int S5[64];
int S6[64];
int S7[64];
int S8[64];

/***************** Prototipi delle funzioni utilizzate *****************/
/*     stampa(numero matrice, posizione dell'elemento nella matrice,  
              valori delle variabili di input per Espresso,           
              valori delle variabili di output per Espresso)           */
void stampa(int,int,int*,int*);

/* conv(matrice da trasformare in file, posizione dell'elemento nella
        matrice, numero matrice)                                       */                
void conv(int*,int,int);
/***********************************************************************/

/* Esegue le operazioni suddette per ciascuna delle 8 S-boxes */  
void main()
{	int i,j; /* Variabili usate come indici per i cicli */
	leggi_S_box(1);
	leggi_S_box(2);
	leggi_S_box(3);
	leggi_S_box(4);
	leggi_S_box(5);
	leggi_S_box(6);
	leggi_S_box(7);
	leggi_S_box(8);
	for(i=0;i<8;i++)
	{	for(j=0;j<64;j++)
		{   switch(i)
			{  case 0: conv(S1,j,i+1); break;
			   case 1: conv(S2,j,i+1); break;
			   case 2: conv(S3,j,i+1); break;
			   case 3: conv(S4,j,i+1); break;
			   case 4: conv(S5,j,i+1); break;
			   case 5: conv(S6,j,i+1); break;
			   case 6: conv(S7,j,i+1); break;
			   case 7: conv(S8,j,i+1); break;
			}
		}
	}
}

/* Data la S-box S, trasforma ciascun elemento della matrice in binario
   e poi lo invia alla funzione stampa per essere scritto su un file    */
void conv(int* S,int in,int matrice)
{	int resto, /* Contiene il resto della divisione per 2 del numero
                  da convertire                                     */
	    i,     /* Variabile usata come indice per i cicli           */
	    diviso=in; /* Contiene il valore della divisione intera per
			          2, viene inizializzato con il numero indicante
			          la posizione nella S-box. Dopo tale conversione,
			          verr inizializzato con il valore del numero
			          contenuto in posizione in-iesima nella S-box. */                          
	int input[6]; /* Contiene, di volta in volta, il valore di input
			         (in binario), relativo ad un particolare
			         elemento, da registrare sul file               */
	int output[6]; /* Contiene, di volta in volta, il valore di
			          output (in binario), relativo ad un particolare
			          elemento, da registrare sul file              */

	/* Conversione dei bits di ingresso alla S-box secondo la
	   tradizionale conversione decimale-binario              */  
	for(i=0;i<6;i++)
	{	resto = diviso%2;
		diviso = diviso/2;
		input[5-i] = resto;
	}
	diviso = S[in];
    /* Conversione dei bits in uscita dalla S-box */
	for(i=0;i<4;i++)
	{	resto = diviso%2;
		diviso = diviso/2;
		output[3-i] = resto;
	}
	/* Scrivi gli elementi input e output della S-boxes
	   sul file appropriato                              */ 
	stampa(matrice,in,input,output);
}

/* Crea per ciascuna S-boxes il file in formato leggibile da Espresso */ 
void stampa(int matrice, int iterazione, int* input, int* output)
{   static FILE* s1;
	static FILE* s2;
	static FILE* s3;
	static FILE* s4;
	int i; /* Variabile usata come indice nei cicli   */
	switch(matrice)
	{	case 1: /* Verifica l'esistenza del file  */
			if(iterazione==0)
			{  /* Se il file non esiste lo crea e lo inizializza */
			   if((s1=fopen("matS11","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS11\n");
			     exit(1);
                           }
			   if((s2=fopen("matS12","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS12\n");
			     exit(1);
                           }
			   if((s3=fopen("matS13","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS13\n");
			     exit(1);
                           }
			   if((s4=fopen("matS14","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS14\n");
			     exit(1);
                           }
			   fprintf(s1,"# Prima S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
			   fprintf(s1,".ilb x1 x6 x2 x3 x4 x5\n");
			   fprintf(s1,".ob s1\n");
			   fprintf(s2,"# Prima S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
			   fprintf(s2,".ilb x1 x6 x2 x3 x4 x5\n");
			   fprintf(s2,".ob s2\n");
			   fprintf(s3,"# Prima S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
			   fprintf(s3,".ilb x1 x6 x2 x3 x4 x5\n");
			   fprintf(s3,".ob s3\n");
			   fprintf(s4,"# Prima S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
			   fprintf(s4,".ilb x1 x6 x2 x3 x4 x5\n");
			   fprintf(s4,".ob s4\n");
			}
                        /* Procede alla scrittura del file  */
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
                        break;
		/* Quanto segue funziona, per le altre S-boxes, in
		   maniera analoga al caso precedente               */
		case 2: 
			if(iterazione==0)
			{  if((s1=fopen("matS21","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS21\n");
			     exit(1);
                           }
			   if((s2=fopen("matS22","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS22\n");
			     exit(1);
                           }
			   if((s3=fopen("matS23","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS23\n");
			     exit(1);
                           }
			   if((s4=fopen("matS24","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS24\n");
			     exit(1);
                           }
			   fprintf(s1,"# Seconda S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
			   fprintf(s1,".ilb x7 x12 x8 x9 x10 x11\n");
			   fprintf(s1,".ob s5\n");
			   fprintf(s2,"# Seconda S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
			   fprintf(s2,".ilb x7 x12 x8 x9 x10 x11\n");
			   fprintf(s2,".ob s6\n");
			   fprintf(s3,"# Seconda S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
			   fprintf(s3,".ilb x7 x12 x8 x9 x10 x11\n");
			   fprintf(s3,".ob s7\n");
			   fprintf(s4,"# Seconda S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
			   fprintf(s4,".ilb x7 x12 x8 x9 x10 x11\n");
			   fprintf(s4,".ob s8\n");
			}
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
                        break;
		case 3: 
			if(iterazione==0)
			{  if((s1=fopen("matS31","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS31\n");
			     exit(1);
                           }
			   if((s2=fopen("matS32","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS32\n");
			     exit(1);
                           }
			   if((s3=fopen("matS33","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS33\n");
			     exit(1);
                           }
			   if((s4=fopen("matS34","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS34\n");
			     exit(1);
                           }
			   fprintf(s1,"# Terza S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
			   fprintf(s1,".ilb x13 x18 x14 x15 x16 x17\n");
			   fprintf(s1,".ob s9\n");
			   fprintf(s2,"# Terza S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
			   fprintf(s2,".ilb x13 x18 x14 x15 x16 x17\n");
			   fprintf(s2,".ob s10\n");
			   fprintf(s3,"# Terza S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
			   fprintf(s3,".ilb x13 x18 x14 x15 x16 x17\n");
			   fprintf(s3,".ob s11\n");
			   fprintf(s4,"# Terza S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
			   fprintf(s4,".ilb x13 x18 x14 x15 x16 x17\n");
			   fprintf(s4,".ob s12\n");
			}
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
			break;
		case 4: 
			if(iterazione==0)
			{  if((s1=fopen("matS41","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS41\n");
			     exit(1);
                           }
			   if((s2=fopen("matS42","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS42\n");
			     exit(1);
                           }
			   if((s3=fopen("matS43","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS43\n");
			     exit(1);
                           }
			   if((s4=fopen("matS44","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS44\n");
			     exit(1);
                           }
			   fprintf(s1,"# Quarta S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
			   fprintf(s1,".ilb x19 x24 x20 x21 x22 x23\n");
			   fprintf(s1,".ob s13\n");
			   fprintf(s2,"# Quarta S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
			   fprintf(s2,".ilb x19 x24 x20 x21 x22 x23\n");
			   fprintf(s2,".ob s14\n");
			   fprintf(s3,"# Quarta S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
			   fprintf(s3,".ilb x19 x24 x20 x21 x22 x23\n");
			   fprintf(s3,".ob s15\n");
			   fprintf(s4,"# Quarta S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
			   fprintf(s4,".ilb x19 x24 x20 x21 x22 x23\n");
			   fprintf(s4,".ob s16\n");
			}
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
			break;
		case 5: 
			if(iterazione==0)
			{  if((s1=fopen("matS51","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS51\n");
			     exit(1);
                           }
			   if((s2=fopen("matS52","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS52\n");
			     exit(1);
                           }
			   if((s3=fopen("matS53","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS53\n");
			     exit(1);
                           }
			   if((s4=fopen("matS54","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS54\n");
			     exit(1);
                           }
			   fprintf(s1,"# Quinta S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
	     	           fprintf(s1,".ilb x25 x30 x26 x27 x28 x29\n");
			   fprintf(s1,".ob s17\n");
			   fprintf(s2,"# Quinta S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
	     	           fprintf(s2,".ilb x25 x30 x26 x27 x28 x29\n");
			   fprintf(s2,".ob s18\n");
			   fprintf(s3,"# Quinta S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
	     	           fprintf(s3,".ilb x25 x30 x26 x27 x28 x29\n");
			   fprintf(s3,".ob s19\n");
			   fprintf(s4,"# Quinta S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
	     	           fprintf(s4,".ilb x25 x30 x26 x27 x28 x29\n");
			   fprintf(s4,".ob s20\n");
			}
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
			break;
		case 6: 
			if(iterazione==0)
			{  if((s1=fopen("matS61","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS61\n");
			     exit(1);
                           }
			   if((s2=fopen("matS62","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS62\n");
			     exit(1);
                           }
			   if((s3=fopen("matS63","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS63\n");
			     exit(1);
                           }
			   if((s4=fopen("matS64","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS64\n");
			     exit(1);
                           }
			   fprintf(s1,"# Sesta S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
			   fprintf(s1,".ilb x31 x36 x32 x33 x34 x35\n");
			   fprintf(s1,".ob s21\n");
			   fprintf(s2,"# Sesta S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
			   fprintf(s2,".ilb x31 x36 x32 x33 x34 x35\n");
			   fprintf(s2,".ob s22\n");
			   fprintf(s3,"# Sesta S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
			   fprintf(s3,".ilb x31 x36 x32 x33 x34 x35\n");
			   fprintf(s3,".ob s23\n");
			   fprintf(s4,"# Sesta S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
			   fprintf(s4,".ilb x31 x36 x32 x33 x34 x35\n");
			   fprintf(s4,".ob s24\n");
			}
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
			break;
		case 7: 
			if(iterazione==0)
			{  if((s1=fopen("matS71","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS71\n");
			     exit(1);
                           }
			   if((s2=fopen("matS72","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS72\n");
			     exit(1);
                           }
			   if((s3=fopen("matS73","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS73\n");
			     exit(1);
                           }
			   if((s4=fopen("matS74","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS74\n");
			     exit(1);
                           }
			   fprintf(s1,"# Settima S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
			   fprintf(s1,".ilb x37 x42 x38 x39 x40 x41\n");
			   fprintf(s1,".ob s25\n");
			   fprintf(s2,"# Settima S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
			   fprintf(s2,".ilb x37 x42 x38 x39 x40 x41\n");
			   fprintf(s2,".ob s26\n");
			   fprintf(s3,"# Settima S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
			   fprintf(s3,".ilb x37 x42 x38 x39 x40 x41\n");
			   fprintf(s3,".ob s27\n");
			   fprintf(s4,"# Settima S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
			   fprintf(s4,".ilb x37 x42 x38 x39 x40 x41\n");
			   fprintf(s4,".ob s28\n");
			}
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
			break;
		case 8: 
			if(iterazione==0)
			{  if((s1=fopen("matS81","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS81\n");
			     exit(1);
                           }
			   if((s2=fopen("matS82","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS82\n");
			     exit(1);
                           }
			   if((s3=fopen("matS83","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS83\n");
			     exit(1);
                           }
			   if((s4=fopen("matS84","wb")==NULL)
			   { printf("Errore: impossibile creare il file matS84\n");
			     exit(1);
                           }
			   fprintf(s1,"# Ottava S-box\n");
			   fprintf(s1,".i 6\n");
			   fprintf(s1,".o 1\n");
			   fprintf(s1,".ilb x43 x48 x44 x45 x46 x47\n");
			   fprintf(s1,".ob s29\n");
			   fprintf(s2,"# Ottava S-box\n");
			   fprintf(s2,".i 6\n");
			   fprintf(s2,".o 1\n");
			   fprintf(s2,".ilb x43 x48 x44 x45 x46 x47\n");
			   fprintf(s2,".ob s30\n");
			   fprintf(s3,"# Ottava S-box\n");
			   fprintf(s3,".i 6\n");
			   fprintf(s3,".o 1\n");
			   fprintf(s3,".ilb x43 x48 x44 x45 x46 x47\n");
			   fprintf(s3,".ob s31\n");
			   fprintf(s4,"# Ottava S-box\n");
			   fprintf(s4,".i 6\n");
			   fprintf(s4,".o 1\n");
			   fprintf(s4,".ilb x43 x48 x44 x45 x46 x47\n");
			   fprintf(s4,".ob s32\n");
			}
			for(i=0;i<6;i++)
			{  fprintf(s1,"%i",input[i]);
			   fprintf(s2,"%i",input[i]);
			   fprintf(s3,"%i",input[i]);
			   fprintf(s4,"%i",input[i]);
                        }
			fprintf(s1," ");
			fprintf(s1,"%i",output[0]);
			fprintf(s1,"\n");
			fprintf(s2," ");
			fprintf(s2,"%i",output[1]);
			fprintf(s2,"\n");
			fprintf(s3," ");
			fprintf(s3,"%i",output[2]);
			fprintf(s3,"\n");
			fprintf(s4," ");
			fprintf(s4,"%i",output[3]);
			fprintf(s4,"\n");
			if(iterazione==63)
			{   fclose(s1);
			    fclose(s2);
			    fclose(s3);
			    fclose(s4);
			}
			break;
        }
}





